/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.MutableRedBlackMap;
import org.jhotdraw8.icollection.NaturalComparator;
import org.jhotdraw8.icollection.PrivateData;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedMapFacade;
import org.jhotdraw8.icollection.immutable.ImmutableNavigableMap;
import org.jhotdraw8.icollection.impl.redblack.RedBlackTree;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;
import org.jhotdraw8.icollection.readonly.ReadOnlyNavigableMap;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedMap;
import org.jhotdraw8.icollection.readonly.ReadOnlySortedMap;
import org.jhotdraw8.icollection.serialization.SortedMapSerializationProxy;

public class RedBlackMap<K, V>
implements ImmutableNavigableMap<K, V>,
Serializable {
    private static final long serialVersionUID = 0L;
    final transient @NonNull RedBlackTree<K, V> root;
    final transient @NonNull Comparator<? super K> comparator;

    protected RedBlackMap(@NonNull PrivateData privateData) {
        this((RedBlackTree)((Map.Entry)privateData.get()).getValue(), (Comparator)((Map.Entry)privateData.get()).getKey());
    }

    protected @NonNull RedBlackMap<K, V> newInstance(@NonNull PrivateData privateData) {
        return new RedBlackMap<K, V>(privateData);
    }

    private @NonNull RedBlackMap<K, V> newInstance(@NonNull Comparator<? super K> comparator, @NonNull RedBlackTree<K, V> root) {
        return this.newInstance(new PrivateData(new AbstractMap.SimpleImmutableEntry<Comparator<? super K>, RedBlackTree<K, V>>(comparator, root)));
    }

    RedBlackMap(@NonNull RedBlackTree<K, V> root, @NonNull Comparator<? super K> comparator) {
        this.root = root;
        this.comparator = comparator;
    }

    public static <K, V> @NonNull RedBlackMap<K, V> copyOf(@NonNull Comparator<? super K> comparator, @NonNull Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        ReadOnlyNavigableMap<K, V> r;
        if (c instanceof RedBlackMap) {
            r = (RedBlackMap)c;
            if (((RedBlackMap)r).comparator.equals(comparator)) {
                return r;
            }
        }
        if (c instanceof MutableRedBlackMap) {
            r = (MutableRedBlackMap)c;
            if (((MutableRedBlackMap)r).comparator.equals(comparator)) {
                return ((MutableRedBlackMap)r).toImmutable();
            }
        }
        return RedBlackMap.sortedOf(comparator).putAll(c);
    }

    @Override
    public @NonNull RedBlackMap<K, V> putAll(@NonNull Map<? extends K, ? extends V> m) {
        return (RedBlackMap)ImmutableNavigableMap.super.putAll((Map)m);
    }

    @Override
    public @NonNull RedBlackMap<K, V> putAll(@NonNull Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        return (RedBlackMap)ImmutableNavigableMap.super.putAll((Iterable)c);
    }

    @Override
    public @NonNull RedBlackMap<K, V> putKeyValues(Object ... kv) {
        return (RedBlackMap)ImmutableNavigableMap.super.putKeyValues(kv);
    }

    @Override
    public @NonNull RedBlackMap<K, V> removeAll(@NonNull Iterable<? extends K> c) {
        return (RedBlackMap)ImmutableNavigableMap.super.removeAll((Iterable)c);
    }

    @Override
    public @NonNull RedBlackMap<K, V> retainAll(@NonNull Iterable<? extends K> c) {
        return (RedBlackMap)ImmutableNavigableMap.super.retainAll((Iterable)c);
    }

    @Override
    public @NonNull RedBlackMap<K, V> retainAll(@NonNull ReadOnlyCollection<? extends K> c) {
        return (RedBlackMap)ImmutableNavigableMap.super.retainAll((ReadOnlyCollection)c);
    }

    public static <K, V> @NonNull RedBlackMap<K, V> copyOf(@NonNull Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        return RedBlackMap.copyOf(NaturalComparator.instance(), c);
    }

    public static <K, V> @NonNull RedBlackMap<K, V> copyOf(@NonNull Map<? extends K, ? extends V> map) {
        return RedBlackMap.of().putAll((Map)map);
    }

    public static <K, V> @NonNull RedBlackMap<K, V> sortedOf(@Nullable Comparator<? super K> comparator) {
        comparator = comparator == null ? NaturalComparator.instance() : comparator;
        return new RedBlackMap(RedBlackTree.of(comparator, new Object[0]), comparator);
    }

    @SafeVarargs
    public static <K, V> @NonNull RedBlackMap<K, V> sortedOf(@Nullable Comparator<? super K> comparator, Map.Entry<K, V> ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return RedBlackMap.sortedOf(comparator).putAll(Arrays.asList(elements));
    }

    public static <K, V> @NonNull RedBlackMap<K, V> of() {
        return new RedBlackMap(RedBlackTree.of(NaturalComparator.instance(), new Object[0]), NaturalComparator.instance());
    }

    @SafeVarargs
    public static <K, V> @NonNull RedBlackMap<K, V> of(Map.Entry<K, V> ... entries) {
        return RedBlackMap.sortedOf(NaturalComparator.instance(), entries);
    }

    @Override
    public @Nullable Map.Entry<K, V> ceilingEntry(K k) {
        return this.root.ceiling((K)k, this.comparator).mapOrNull(AbstractMap.SimpleImmutableEntry::new);
    }

    @Override
    public @Nullable Comparator<? super K> comparator() {
        return this.comparator == NaturalComparator.instance() ? null : this.comparator;
    }

    @Override
    public @Nullable Map.Entry<K, V> floorEntry(K k) {
        return this.root.floor((K)k, this.comparator).mapOrNull(AbstractMap.SimpleImmutableEntry::new);
    }

    @Override
    public @Nullable Map.Entry<K, V> higherEntry(K k) {
        return this.root.higher((K)k, this.comparator).mapOrNull(AbstractMap.SimpleImmutableEntry::new);
    }

    @Override
    public @Nullable Map.Entry<K, V> lowerEntry(K k) {
        return this.root.lower((K)k, this.comparator).mapOrNull(AbstractMap.SimpleImmutableEntry::new);
    }

    @Override
    public @Nullable Map.Entry<K, V> firstEntry() {
        return this.root.min().mapOrNull(AbstractMap.SimpleImmutableEntry::new);
    }

    @Override
    public @Nullable Map.Entry<K, V> lastEntry() {
        return this.root.max().mapOrNull(AbstractMap.SimpleImmutableEntry::new);
    }

    @Override
    public @NonNull RedBlackMap<K, V> clear() {
        return this.isEmpty() ? this : RedBlackMap.sortedOf(this.comparator);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public @NonNull ReadOnlySequencedMap<K, V> readOnlyReversed() {
        return new ReadOnlySequencedMapFacade<Object, Object>(this::reverseIterator, this::iterator, this::size, this::containsKey, this::get, this::lastEntry, this::firstEntry, 81, null);
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public @Nullable V get(Object key) {
        return this.root.find((K)key, this.comparator).valueOrNull();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.root.contains((K)key, this.comparator);
    }

    @Override
    public @NonNull Iterator<Map.Entry<K, V>> iterator() {
        return this.root.iterator();
    }

    @NonNull Iterator<Map.Entry<K, V>> reverseIterator() {
        return this.root.reverseIterator();
    }

    @Override
    public @NonNull RedBlackMap<K, V> put(@NonNull K key, @Nullable V value) {
        RedBlackTree<? super K, V> newRoot = this.root.insert((K)key, value, this.comparator);
        return newRoot == this.root ? this : this.newInstance(this.comparator, newRoot);
    }

    @Override
    public @NonNull RedBlackMap<K, V> remove(@NonNull K key) {
        RedBlackTree<? super K, V> newRoot = this.root.delete((K)key, this.comparator);
        return newRoot == this.root ? this : this.newInstance(this.comparator, newRoot);
    }

    @Override
    public @NonNull MutableRedBlackMap<K, V> toMutable() {
        return new MutableRedBlackMap<K, V>(this.root, this.comparator);
    }

    @Override
    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean equals(Object o) {
        return ReadOnlySortedMap.sortedMapEquals(this, o);
    }

    @Override
    public int hashCode() {
        return ReadOnlyMap.iteratorToHashCode(this.iterator());
    }

    public String toString() {
        return ReadOnlyMap.mapToString(this);
    }

    @Override
    public int characteristics() {
        return 1109;
    }

    private @NonNull Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.toMutable());
    }

    private static class SerializationProxy<K, V>
    extends SortedMapSerializationProxy<K, V> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(SortedMap<K, V> target) {
            super(target);
        }

        @Override
        protected @NonNull Object readResolve() {
            return RedBlackMap.sortedOf(this.deserializedComparator).putAll((Iterable)this.deserializedEntries);
        }
    }
}

