/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.MutableRedBlackSet;
import org.jhotdraw8.icollection.NaturalComparator;
import org.jhotdraw8.icollection.PrivateData;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedSetFacade;
import org.jhotdraw8.icollection.immutable.ImmutableCollection;
import org.jhotdraw8.icollection.immutable.ImmutableNavigableSet;
import org.jhotdraw8.icollection.impl.iteration.MappedIterator;
import org.jhotdraw8.icollection.impl.redblack.Node;
import org.jhotdraw8.icollection.impl.redblack.RedBlackTree;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedSet;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jhotdraw8.icollection.serialization.SortedSetSerializationProxy;

public class RedBlackSet<E>
implements ImmutableNavigableSet<E>,
Serializable {
    private static final long serialVersionUID = 0L;
    final transient @NonNull RedBlackTree<E, Void> root;
    final @NonNull Comparator<E> comparator;

    protected RedBlackSet(@NonNull PrivateData privateData) {
        this((Comparator)((Map.Entry)privateData.get()).getKey(), (RedBlackTree)((Map.Entry)privateData.get()).getValue());
    }

    protected @NonNull RedBlackSet<E> newInstance(@NonNull PrivateData privateData) {
        return new RedBlackSet<E>(privateData);
    }

    private @NonNull RedBlackSet<E> newInstance(@NonNull Comparator<E> comparator, @NonNull RedBlackTree<E, Void> root) {
        return this.newInstance(new PrivateData(new AbstractMap.SimpleImmutableEntry<Comparator<E>, RedBlackTree<E, Void>>(comparator, root)));
    }

    RedBlackSet(@NonNull Comparator<E> comparator, @NonNull RedBlackTree<E, Void> root) {
        this.root = root;
        this.comparator = comparator;
    }

    public static <E> @NonNull RedBlackSet<E> copyOf(@Nullable Comparator<E> comparator, @NonNull Iterable<? extends E> c) {
        Serializable r;
        if (comparator == null) {
            comparator = NaturalComparator.instance();
        }
        if (c instanceof RedBlackSet) {
            r = (RedBlackSet)c;
            if (((RedBlackSet)r).comparator.equals(comparator)) {
                return r;
            }
        }
        if (c instanceof MutableRedBlackSet) {
            r = (MutableRedBlackSet)c;
            if (((MutableRedBlackSet)r).comparator.equals(comparator)) {
                return ((MutableRedBlackSet)r).toImmutable();
            }
        }
        return RedBlackSet.sortedOf(comparator).addAll(c);
    }

    public static <E> @NonNull RedBlackSet<E> copyOf(@NonNull Iterable<? extends E> c) {
        return RedBlackSet.copyOf(NaturalComparator.instance(), c);
    }

    public static <E> @NonNull RedBlackSet<E> sortedOf(@Nullable Comparator<E> comparator) {
        if (comparator == null) {
            comparator = NaturalComparator.instance();
        }
        return new RedBlackSet<Object>(comparator, RedBlackTree.of(comparator, new Object[0]));
    }

    @SafeVarargs
    public static <E> @NonNull RedBlackSet<E> sortedOf(@Nullable Comparator<E> comparator, E ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (comparator == null) {
            comparator = NaturalComparator.instance();
        }
        return RedBlackSet.sortedOf(comparator).addAll((Iterable)Arrays.asList(elements));
    }

    public static <E> @NonNull RedBlackSet<E> of() {
        return new RedBlackSet<Object>(NaturalComparator.instance(), RedBlackTree.of(NaturalComparator.instance(), new Object[0]));
    }

    @SafeVarargs
    public static <E> @NonNull RedBlackSet<E> of(E ... elements) {
        return RedBlackSet.sortedOf(NaturalComparator.instance(), elements);
    }

    @Override
    public @NonNull RedBlackSet<E> add(E element) {
        RedBlackTree<E, Object> newRoot = this.root.insert(element, null, this.comparator);
        return newRoot == this.root ? this : this.newInstance(this.comparator, newRoot);
    }

    @Override
    public E getFirst() {
        return this.root.min().getKey();
    }

    @Override
    public E getLast() {
        return this.root.max().getKey();
    }

    @Override
    public @NonNull RedBlackSet<E> addAll(@NonNull Iterable<? extends E> c) {
        return (RedBlackSet)ImmutableNavigableSet.super.addAll((Iterable)c);
    }

    @Override
    public @Nullable E ceiling(E e) {
        return this.root.ceiling(e, this.comparator).keyOrNull();
    }

    @Override
    public <T> @NonNull RedBlackSet<T> empty() {
        return RedBlackSet.of();
    }

    @Override
    public <T> @NonNull ImmutableCollection<T> empty(@Nullable Comparator<T> comparator) {
        return RedBlackSet.sortedOf(comparator);
    }

    @Override
    public @Nullable Comparator<? super E> comparator() {
        return this.comparator == NaturalComparator.instance() ? null : this.comparator;
    }

    @Override
    public boolean contains(Object o) {
        return this.root.contains(o, this.comparator);
    }

    @Override
    public @Nullable E floor(E e) {
        return this.root.floor(e, this.comparator).keyOrNull();
    }

    @Override
    public @Nullable E higher(E e) {
        return this.root.higher(e, this.comparator).keyOrNull();
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new MappedIterator<Object, Node>(this.root.iterator(), Map.Entry::getKey);
    }

    @Override
    public Spliterator<E> spliterator() {
        return new Spliterators.AbstractSpliterator<E>(this.size(), 1109){
            private final Iterator<E> iterator;
            {
                this.iterator = RedBlackSet.this.iterator();
            }

            @Override
            public boolean tryAdvance(@NonNull Consumer<? super E> action) {
                if (this.iterator.hasNext()) {
                    action.accept(this.iterator.next());
                }
                return false;
            }

            @Override
            public Comparator<? super E> getComparator() {
                return RedBlackSet.this.comparator();
            }
        };
    }

    @Override
    public @Nullable E lower(E e) {
        return this.root.lower(e, this.comparator).keyOrNull();
    }

    @Override
    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public @NonNull ReadOnlySequencedSet<E> readOnlyReversed() {
        return new ReadOnlySequencedSetFacade<Object>(this::reverseIterator, this::iterator, this::size, this::contains, this::getLast, this::getFirst, 1024);
    }

    @Override
    public @NonNull RedBlackSet<E> remove(E element) {
        RedBlackTree<E, Void> newRoot = this.root.delete(element, this.comparator);
        return newRoot.size() == this.root.size() ? this : this.newInstance(this.comparator, newRoot);
    }

    @Override
    public @NonNull RedBlackSet<E> removeAll(@NonNull Iterable<?> c) {
        return (RedBlackSet)ImmutableNavigableSet.super.removeAll((Iterable)c);
    }

    @Override
    public @NonNull RedBlackSet<E> retainAll(@NonNull Iterable<?> c) {
        return (RedBlackSet)ImmutableNavigableSet.super.retainAll((Iterable)c);
    }

    @NonNull Iterator<E> reverseIterator() {
        return new MappedIterator<Object, Node>(this.root.reverseIterator(), Map.Entry::getKey);
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public int hashCode() {
        return ReadOnlySet.iteratorToHashCode(this.iterator());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return ReadOnlySet.setEquals(this, other);
    }

    @Override
    public @NonNull MutableRedBlackSet<E> toMutable() {
        return new MutableRedBlackSet<E>(this.comparator, this.root);
    }

    public String toString() {
        return ReadOnlyCollection.iterableToString(this);
    }

    private @NonNull Object writeReplace() {
        return new SerializationProxy(this.toMutable());
    }

    private static class SerializationProxy<E>
    extends SortedSetSerializationProxy<E> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(@NonNull SortedSet<E> target) {
            super(target);
        }

        @Override
        protected @NonNull Object readResolve() {
            return RedBlackSet.copyOf(this.deserializedComparator, this.deserializedElements);
        }
    }
}

