/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.icollection.readonly.AbstractReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedCollection;

public class ReadOnlyListFacade<E>
extends AbstractReadOnlyList<E> {
    private final @NonNull IntSupplier sizeFunction;
    private final @NonNull IntFunction<E> getFunction;
    private final @NonNull Supplier<ReadOnlySequencedCollection<E>> readOnlyReversedFunction;

    public ReadOnlyListFacade(@NonNull List<E> backingList) {
        this.sizeFunction = backingList::size;
        this.getFunction = backingList::get;
        this.readOnlyReversedFunction = () -> new ReadOnlyListFacade<Object>(this.sizeFunction, index -> this.getFunction.apply(this.sizeFunction.getAsInt() - index), () -> this);
    }

    public ReadOnlyListFacade(@NonNull IntSupplier sizeFunction, @NonNull IntFunction<E> getFunction) {
        this.sizeFunction = sizeFunction;
        this.getFunction = getFunction;
        this.readOnlyReversedFunction = () -> new ReadOnlyListFacade<Object>(sizeFunction, index -> getFunction.apply(sizeFunction.getAsInt() - index), () -> this);
    }

    public ReadOnlyListFacade(@NonNull IntSupplier sizeFunction, @NonNull IntFunction<E> getFunction, @NonNull Supplier<ReadOnlySequencedCollection<E>> readOnlyReversedFunction) {
        this.sizeFunction = sizeFunction;
        this.getFunction = getFunction;
        this.readOnlyReversedFunction = readOnlyReversedFunction;
    }

    @Override
    public E get(int index) {
        return this.getFunction.apply(index);
    }

    @Override
    public @NonNull ReadOnlySequencedCollection<E> readOnlyReversed() {
        return this.readOnlyReversedFunction.get();
    }

    @Override
    public @NonNull ReadOnlyList<E> readOnlySubList(int fromIndex, int toIndex) {
        int length = this.size();
        Objects.checkFromToIndex(fromIndex, toIndex, length);
        return new ReadOnlyListFacade<Object>(() -> toIndex - fromIndex, i -> this.getFunction.apply(i - fromIndex), this.readOnlyReversedFunction);
    }

    @Override
    public int size() {
        return this.sizeFunction.getAsInt();
    }
}

