/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SequencedMap;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.facade.ReadOnlyMapFacade;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedMap;

public class ReadOnlySequencedMapFacade<K, V>
extends ReadOnlyMapFacade<K, V>
implements ReadOnlySequencedMap<K, V> {
    private final @NonNull Supplier<Map.Entry<K, V>> firstEntryFunction;
    private final @NonNull Supplier<Map.Entry<K, V>> lastEntryFunction;
    private final @NonNull Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction;
    private final int characteristics;
    private final @Nullable Comparator<? super K> comparator;

    public ReadOnlySequencedMapFacade(@NonNull SequencedMap<K, V> target) {
        super(target);
        this.firstEntryFunction = target::firstEntry;
        this.lastEntryFunction = target::lastEntry;
        this.reverseIteratorFunction = () -> target.reversed().sequencedEntrySet().iterator();
        this.characteristics = 81;
        this.comparator = null;
    }

    public ReadOnlySequencedMapFacade(@NonNull Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction, @NonNull Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction, @NonNull IntSupplier sizeFunction, @NonNull Predicate<Object> containsKeyFunction, @NonNull Function<K, V> getFunction, @NonNull Supplier<Map.Entry<K, V>> firstEntryFunction, @NonNull Supplier<Map.Entry<K, V>> lastEntryFunction, int characteristics, @Nullable Comparator<? super K> comparator) {
        super(iteratorFunction, sizeFunction, containsKeyFunction, getFunction);
        this.firstEntryFunction = firstEntryFunction;
        this.lastEntryFunction = lastEntryFunction;
        this.reverseIteratorFunction = reverseIteratorFunction;
        this.characteristics = characteristics;
        this.comparator = comparator;
    }

    @Override
    public @NonNull ReadOnlySequencedMap<K, V> readOnlyReversed() {
        return new ReadOnlySequencedMapFacade<K, V>(this.reverseIteratorFunction, this.iteratorFunction, this.sizeFunction, this.containsKeyFunction, this.getFunction, this.lastEntryFunction, this.firstEntryFunction, this.characteristics, this.comparator);
    }

    @Override
    public  @Nullable Map.Entry<K, V> firstEntry() {
        return this.firstEntryFunction.get();
    }

    @Override
    public  @Nullable Map.Entry<K, V> lastEntry() {
        return this.lastEntryFunction.get();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

