/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.facade.ReadOnlySetFacade;
import org.jhotdraw8.icollection.readonly.ReadOnlySortedSet;

public class ReadOnlySortedSetFacade<E>
extends ReadOnlySetFacade<E>
implements ReadOnlySortedSet<E> {
    final @NonNull Supplier<E> getFirstFunction;
    final @NonNull Supplier<E> getLastFunction;
    final @NonNull Supplier<Comparator<? super E>> comparatorSupplier;
    final @NonNull Supplier<Iterator<E>> reverseIteratorFunction;

    public ReadOnlySortedSetFacade(@NonNull SortedSet<E> s) {
        this(s::iterator, () -> s.reversed().iterator(), s::size, s::contains, s::getFirst, s::getLast, s::comparator, 81);
    }

    public ReadOnlySortedSetFacade(@NonNull Supplier<Iterator<E>> iteratorFunction, @NonNull Supplier<Iterator<E>> reverseIteratorFunction, @NonNull IntSupplier sizeFunction, @NonNull Predicate<Object> containsFunction, @NonNull Supplier<E> getFirstFunction, @NonNull Supplier<E> getLastFunction, @NonNull Supplier<Comparator<? super E>> comparatorSupplier, int characteristics) {
        super(iteratorFunction, sizeFunction, containsFunction, characteristics);
        this.getFirstFunction = getFirstFunction;
        this.getLastFunction = getLastFunction;
        this.reverseIteratorFunction = reverseIteratorFunction;
        this.comparatorSupplier = comparatorSupplier;
    }

    @Override
    public @Nullable Comparator<? super E> comparator() {
        return this.comparatorSupplier.get();
    }

    @Override
    public E getLast() {
        return this.getLastFunction.get();
    }

    @Override
    public @NonNull ReadOnlySortedSet<E> readOnlyReversed() {
        return new ReadOnlySortedSetFacade<E>(this.reverseIteratorFunction, this.iteratorFunction, this.sizeFunction, this.containsFunction, this.getLastFunction, this.getFirstFunction, () -> this.comparatorSupplier.get().reversed(), this.characteristics);
    }
}

