/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.SequencedMap;
import java.util.SequencedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.facade.MapFacade;
import org.jhotdraw8.icollection.facade.SequencedCollectionFacade;
import org.jhotdraw8.icollection.facade.SequencedSetFacade;
import org.jhotdraw8.icollection.impl.iteration.MappedIterator;
import org.jhotdraw8.icollection.impl.iteration.MappedSpliterator;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedMap;

public class SequencedMapFacade<K, V>
extends MapFacade<K, V>
implements SequencedMap<K, V> {
    private final @NonNull Supplier<Map.Entry<K, V>> firstEntryFunction;
    private final @NonNull Supplier<Map.Entry<K, V>> lastEntryFunction;
    private final @NonNull BiFunction<K, V, V> putFirstFunction;
    private final @NonNull BiFunction<K, V, V> putLastFunction;
    private final @NonNull Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction;
    private final @NonNull Supplier<Spliterator<Map.Entry<K, V>>> reverseSpliteratorFunction;

    public SequencedMapFacade(@NonNull ReadOnlySequencedMap<K, V> m) {
        super(m);
        this.firstEntryFunction = m::firstEntry;
        this.lastEntryFunction = m::lastEntry;
        this.putFirstFunction = (k, v) -> {
            throw new UnsupportedOperationException();
        };
        this.putLastFunction = (k, v) -> {
            throw new UnsupportedOperationException();
        };
        this.reverseIteratorFunction = () -> m.readOnlyReversed().iterator();
        this.reverseSpliteratorFunction = () -> m.readOnlyReversed().spliterator();
    }

    public SequencedMapFacade(@NonNull SequencedMap<K, V> m) {
        super(m);
        this.firstEntryFunction = m::firstEntry;
        this.lastEntryFunction = m::lastEntry;
        this.putFirstFunction = m::putFirst;
        this.putLastFunction = m::putLast;
        this.reverseIteratorFunction = () -> m.reversed().sequencedEntrySet().iterator();
        this.reverseSpliteratorFunction = () -> m.reversed().sequencedEntrySet().spliterator();
    }

    public SequencedMapFacade(@NonNull Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction, @NonNull Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction, @NonNull IntSupplier sizeFunction, @NonNull Predicate<Object> containsKeyFunction, @NonNull Function<K, V> getFunction, @Nullable Runnable clearFunction, @Nullable Function<Object, V> removeFunction, @NonNull Supplier<Map.Entry<K, V>> firstEntryFunction, @NonNull Supplier<Map.Entry<K, V>> lastEntryFunction, @Nullable BiFunction<K, V, V> putFunction, @Nullable BiFunction<K, V, V> putFirstFunction, @Nullable BiFunction<K, V, V> putLastFunction) {
        this(iteratorFunction, () -> Spliterators.spliterator((Iterator)iteratorFunction.get(), (long)sizeFunction.getAsInt(), 1), reverseIteratorFunction, () -> Spliterators.spliterator((Iterator)reverseIteratorFunction.get(), (long)sizeFunction.getAsInt(), 1), sizeFunction, containsKeyFunction, getFunction, clearFunction, removeFunction, firstEntryFunction, lastEntryFunction, putFunction, putFirstFunction, putLastFunction);
    }

    public SequencedMapFacade(@NonNull Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction, @NonNull Supplier<Spliterator<Map.Entry<K, V>>> spliteratorFunction, @NonNull Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction, @NonNull Supplier<Spliterator<Map.Entry<K, V>>> reverseSpliteratorFunction, @NonNull IntSupplier sizeFunction, @NonNull Predicate<Object> containsKeyFunction, @NonNull Function<K, V> getFunction, @Nullable Runnable clearFunction, @Nullable Function<Object, V> removeFunction, @NonNull Supplier<Map.Entry<K, V>> firstEntryFunction, @NonNull Supplier<Map.Entry<K, V>> lastEntryFunction, @Nullable BiFunction<K, V, V> putFunction, @Nullable BiFunction<K, V, V> putFirstFunction, @Nullable BiFunction<K, V, V> putLastFunction) {
        super(iteratorFunction, spliteratorFunction, sizeFunction, containsKeyFunction, getFunction, clearFunction, removeFunction, putFunction);
        this.firstEntryFunction = firstEntryFunction;
        this.lastEntryFunction = lastEntryFunction;
        this.putFirstFunction = putFirstFunction == null ? (k, v) -> {
            throw new UnsupportedOperationException();
        } : putFirstFunction;
        this.putLastFunction = putLastFunction == null ? (k, v) -> {
            throw new UnsupportedOperationException();
        } : putLastFunction;
        this.reverseIteratorFunction = reverseIteratorFunction;
        this.reverseSpliteratorFunction = reverseSpliteratorFunction;
    }

    public static <K, V> @NonNull SequencedSet<K> createKeySet(@NonNull SequencedMap<K, V> m) {
        return new SequencedSetFacade<Object>(() -> new MappedIterator<Object, Map.Entry>(m.sequencedEntrySet().iterator(), Map.Entry::getKey), () -> new MappedSpliterator<Object, Map.Entry>(m.sequencedEntrySet().spliterator(), Map.Entry::getKey, 81, null), () -> new MappedIterator<Object, Map.Entry>(m.reversed().sequencedEntrySet().iterator(), Map.Entry::getKey), () -> new MappedSpliterator<Object, Map.Entry>(m.reversed().sequencedEntrySet().spliterator(), Map.Entry::getKey, 81, null), m::size, m::containsKey, m::clear, o -> {
            if (m.containsKey(o)) {
                m.remove(o);
                return true;
            }
            return false;
        }, () -> {
            Map.Entry e = m.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }, () -> {
            Map.Entry e = m.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }, null, null, null, null);
    }

    public static <K, V> @NonNull SequencedCollection<V> createValues(@NonNull SequencedMap<K, V> m) {
        return new SequencedCollectionFacade<Object>(() -> new MappedIterator<Object, Map.Entry>(m.sequencedEntrySet().iterator(), Map.Entry::getValue), () -> new MappedIterator<Object, Map.Entry>(m.reversed().sequencedEntrySet().iterator(), Map.Entry::getValue), m::size, m::containsValue, m::clear, o -> {
            for (Map.Entry entry : m.sequencedEntrySet()) {
                if (!Objects.equals(entry.getValue(), o)) continue;
                m.remove(entry.getKey());
                return true;
            }
            return false;
        }, () -> {
            Map.Entry entry = m.firstEntry();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getValue();
        }, () -> {
            Map.Entry entry = m.lastEntry();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getValue();
        }, null, null, null);
    }

    @Override
    public @NonNull SequencedSet<Map.Entry<K, V>> sequencedEntrySet() {
        return new SequencedSetFacade<Map.Entry<K, V>>(this.iteratorFunction, this.spliteratorFunction, this.reverseIteratorFunction, this.reverseSpliteratorFunction, this.sizeFunction, this::containsEntry, this.clearFunction, this::removeEntry, this.firstEntryFunction, this.lastEntryFunction, null, null, null, null);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.firstEntryFunction.get();
    }

    @Override
    public @NonNull SequencedSet<K> sequencedKeySet() {
        return new SequencedSetFacade<Object>(() -> new MappedIterator<Object, Map.Entry>((Iterator)this.iteratorFunction.get(), Map.Entry::getKey), () -> new MappedSpliterator<Object, Map.Entry>((Spliterator)this.spliteratorFunction.get(), Map.Entry::getKey, 65, null), () -> new MappedIterator<Object, Map.Entry>(this.reverseIteratorFunction.get(), Map.Entry::getKey), () -> new MappedSpliterator<Object, Map.Entry>((Spliterator)this.spliteratorFunction.get(), Map.Entry::getKey, 65, null), this.sizeFunction, this::containsKey, this.clearFunction, this::removeEntry, () -> {
            Map.Entry<K, V> e = this.lastEntryFunction.get();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }, () -> {
            Map.Entry<K, V> e = this.firstEntryFunction.get();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.getKey();
        }, null, null, null, null);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.lastEntryFunction.get();
    }

    @Override
    public @Nullable V putFirst(K k, V v) {
        return this.putFirstFunction.apply(k, v);
    }

    @Override
    public @Nullable V putLast(K k, V v) {
        return this.putLastFunction.apply(k, v);
    }

    @Override
    public @NonNull SequencedMap<K, V> reversed() {
        return new SequencedMapFacade<K, V>(this.reverseIteratorFunction, this.iteratorFunction, this.sizeFunction, this.containsKeyFunction, this.getFunction, this.clearFunction, this.removeFunction, this.lastEntryFunction, this.firstEntryFunction, this.putFunction, this.putLastFunction, this.putFirstFunction);
    }

    @Override
    public @NonNull SequencedCollection<V> sequencedValues() {
        return new SequencedCollectionFacade<Object>(() -> new MappedIterator<Object, Map.Entry>((Iterator)this.iteratorFunction.get(), Map.Entry::getValue), () -> new MappedIterator<Object, Map.Entry>(this.reverseIteratorFunction.get(), Map.Entry::getValue), this.sizeFunction, this::containsKey, this.clearFunction, this::removeEntry, () -> {
            Map.Entry<K, V> entry = this.firstEntry();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getValue();
        }, () -> {
            Map.Entry<K, V> entry = this.lastEntry();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getValue();
        }, null, null, null);
    }
}

