/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.immutable;

import java.util.Collection;
import java.util.Set;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.icollection.immutable.ImmutableCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public interface ImmutableSet<E>
extends ReadOnlySet<E>,
ImmutableCollection<E> {
    @Override
    public <T> @NonNull ImmutableSet<T> empty();

    @Override
    public @NonNull ImmutableSet<E> add(E var1);

    @Override
    default public @NonNull ImmutableSet<E> addAll(@NonNull Iterable<? extends E> c) {
        ReadOnlyCollection rc;
        Collection co;
        if (c instanceof Collection && (co = (Collection)c).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            return this;
        }
        if (this.isEmpty() && c.getClass() == this.getClass()) {
            return (ImmutableSet)c;
        }
        ImmutableCollection<E> s = this;
        for (E e : c) {
            s = s.add((Object)e);
        }
        return s;
    }

    @Override
    public @NonNull ImmutableSet<E> remove(E var1);

    @Override
    default public @NonNull ImmutableSet<E> removeAll(@NonNull Iterable<?> c) {
        ReadOnlyCollection rc;
        Collection co;
        if (this.isEmpty() || c instanceof Collection && (co = (Collection)c).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            return this;
        }
        ImmutableCollection<E> s = this;
        for (Object e : c) {
            s = s.remove(e);
        }
        return s;
    }

    @Override
    default public @NonNull ImmutableSet<E> retainAll(@NonNull Iterable<?> c) {
        ImmutableCollection<E> s;
        ReadOnlyCollection rc;
        Collection co;
        if (this.isEmpty()) {
            return this;
        }
        if (c instanceof Collection && (co = (Collection)((Object)c)).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            return this.empty();
        }
        if (c instanceof Collection) {
            co = (Collection)((Object)c);
            s = this;
            for (Object e : this) {
                if (co.contains(e)) continue;
                s = s.remove(e);
            }
            return s;
        }
        if (!(c instanceof ReadOnlyCollection)) {
            ImmutableCollection clear = this.empty();
            c = clear.addAll((Iterable)c);
        }
        ReadOnlyCollection rc2 = c;
        s = this;
        for (Object e : this) {
            if (rc2.contains(e)) continue;
            s = s.remove(e);
        }
        return s;
    }

    @Override
    public @NonNull Set<E> toMutable();
}

