/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champ;

import java.util.AbstractMap;
import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.champ.SequencedData;

public class SequencedEntry<K, V>
extends AbstractMap.SimpleImmutableEntry<K, V>
implements SequencedData {
    private static final long serialVersionUID = 0L;
    private final int sequenceNumber;

    public SequencedEntry(@Nullable K key) {
        super(key, null);
        this.sequenceNumber = Integer.MIN_VALUE;
    }

    public SequencedEntry(@Nullable K key, @Nullable V value, int sequenceNumber) {
        super(key, value);
        this.sequenceNumber = sequenceNumber;
    }

    public static <K, V> boolean keyEquals(@NonNull SequencedEntry<K, V> a, @NonNull SequencedEntry<K, V> b) {
        return Objects.equals(a.getKey(), b.getKey());
    }

    public static <V, K> int entryKeyHash(@NonNull SequencedEntry<K, V> a) {
        return Objects.hashCode(a.getKey());
    }

    public static int keyHash(@NonNull Object a) {
        return Objects.hashCode(a);
    }

    public static <K, V> @NonNull SequencedEntry<K, V> update(@NonNull SequencedEntry<K, V> oldK, @NonNull SequencedEntry<K, V> newK) {
        return Objects.equals(oldK.getValue(), newK.getValue()) ? oldK : new SequencedEntry(oldK.getKey(), newK.getValue(), oldK.getSequenceNumber());
    }

    public static <K, V> @NonNull SequencedEntry<K, V> updateAndMoveToFirst(@NonNull SequencedEntry<K, V> oldK, @NonNull SequencedEntry<K, V> newK) {
        return Objects.equals(oldK.getValue(), newK.getValue()) && oldK.sequenceNumber == newK.sequenceNumber + 1 ? oldK : (oldK.sequenceNumber == newK.sequenceNumber + 1 ? new SequencedEntry(oldK.getKey(), newK.getValue(), oldK.sequenceNumber) : newK);
    }

    public static <K, V> @NonNull SequencedEntry<K, V> updateAndMoveToLast(@NonNull SequencedEntry<K, V> oldK, @NonNull SequencedEntry<K, V> newK) {
        return Objects.equals(oldK.getValue(), newK.getValue()) && oldK.sequenceNumber == newK.sequenceNumber - 1 ? oldK : (oldK.sequenceNumber == newK.sequenceNumber - 1 ? new SequencedEntry(oldK.getKey(), newK.getValue(), oldK.sequenceNumber) : newK);
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }
}

