/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champmap;

import java.util.Objects;
import java.util.function.ToIntFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.ArrayHelper;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champmap.ChampTrie;
import org.jhotdraw8.icollection.impl.champmap.ChangeEvent;
import org.jhotdraw8.icollection.impl.champmap.EditableMapEntry;
import org.jhotdraw8.icollection.impl.champmap.Node;

public class BitmapIndexedNode<K, V>
extends Node<K, V> {
    static final @NonNull BitmapIndexedNode<?, ?> EMPTY_NODE = ChampTrie.newBitmapIndexedNode(null, 0, 0, new Object[0]);
    public final Object @NonNull [] mixed;
    private final int nodeMap;
    private final int dataMap;

    protected BitmapIndexedNode(int nodeMap, int dataMap, @NonNull Object @NonNull [] mixed) {
        this.nodeMap = nodeMap;
        this.dataMap = dataMap;
        this.mixed = mixed;
        assert (mixed.length == this.nodeArity() + this.dataArity() * 2);
    }

    public static <K, V> @NonNull BitmapIndexedNode<K, V> emptyNode() {
        return EMPTY_NODE;
    }

    @NonNull BitmapIndexedNode<K, V> copyAndInsertValue(@Nullable IdentityObject mutator, int bitpos, K key, V val) {
        int idx = 2 * this.dataIndex(bitpos);
        Object[] dst = ArrayHelper.copyComponentAdd(this.mixed, idx, 2);
        dst[idx] = key;
        dst[idx + 1] = val;
        return ChampTrie.newBitmapIndexedNode(mutator, this.nodeMap, this.dataMap | bitpos, dst);
    }

    @NonNull BitmapIndexedNode<K, V> copyAndMigrateFromDataToNode(@Nullable IdentityObject mutator, int bitpos, Node<K, V> node) {
        int idxOld = 2 * this.dataIndex(bitpos);
        int idxNew = this.mixed.length - 2 - this.nodeIndex(bitpos);
        assert (idxOld <= idxNew);
        Object[] src = this.mixed;
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        dst[idxNew] = node;
        return ChampTrie.newBitmapIndexedNode(mutator, this.nodeMap | bitpos, this.dataMap ^ bitpos, dst);
    }

    @NonNull BitmapIndexedNode<K, V> copyAndMigrateFromNodeToData(@Nullable IdentityObject mutator, int bitpos, @NonNull Node<K, V> node) {
        int idxOld = this.mixed.length - 1 - this.nodeIndex(bitpos);
        int idxNew = 2 * this.dataIndex(bitpos);
        Object[] src = this.mixed;
        Object[] dst = new Object[src.length - 1 + 2];
        assert (idxOld >= idxNew);
        System.arraycopy(src, 0, dst, 0, idxNew);
        System.arraycopy(src, idxNew, dst, idxNew + 2, idxOld - idxNew);
        System.arraycopy(src, idxOld + 1, dst, idxOld + 2, src.length - idxOld - 1);
        Object[] entry = node.getDataEntry(0);
        System.arraycopy(entry, 0, dst, idxNew, 2);
        return ChampTrie.newBitmapIndexedNode(mutator, this.nodeMap ^ bitpos, this.dataMap | bitpos, dst);
    }

    @NonNull BitmapIndexedNode<K, V> copyAndSetNode(@Nullable IdentityObject mutator, int bitpos, Node<K, V> node) {
        int idx = this.mixed.length - 1 - this.nodeIndex(bitpos);
        if (this.isAllowedToEdit(mutator)) {
            this.mixed[idx] = node;
            return this;
        }
        Object[] dst = ArrayHelper.copySet(this.mixed, idx, node);
        return ChampTrie.newBitmapIndexedNode(mutator, this.nodeMap, this.dataMap, dst);
    }

    @NonNull BitmapIndexedNode<K, V> copyAndSetValue(@Nullable IdentityObject mutator, int bitpos, V val) {
        int idx = 2 * this.dataIndex(bitpos) + 1;
        if (this.isAllowedToEdit(mutator)) {
            this.mixed[idx] = val;
            return this;
        }
        Object[] dst = ArrayHelper.copySet(this.mixed, idx, val);
        return ChampTrie.newBitmapIndexedNode(mutator, this.nodeMap, this.dataMap, dst);
    }

    @Override
    int dataArity() {
        return Integer.bitCount(this.dataMap);
    }

    int dataIndex(int bitpos) {
        return Integer.bitCount(this.dataMap & bitpos - 1);
    }

    public int dataMap() {
        return this.dataMap;
    }

    @Override
    public boolean equivalent(@NonNull Object other) {
        if (this == other) {
            return true;
        }
        BitmapIndexedNode that = (BitmapIndexedNode)other;
        Object[] thatNodes = that.mixed;
        int splitAt = 2 * this.dataArity();
        return this.nodeMap() == that.nodeMap() && this.dataMap() == that.dataMap() && ArrayHelper.equals(this.mixed, 0, splitAt, thatNodes, 0, splitAt) && ArrayHelper.equals(this.mixed, splitAt, this.mixed.length, thatNodes, splitAt, thatNodes.length, (a, b) -> ((Node)a).equivalent(b));
    }

    @Override
    public @Nullable Object findByKey(K key, int keyHash, int shift) {
        int index;
        int bitpos = BitmapIndexedNode.bitpos(BitmapIndexedNode.mask(keyHash, shift));
        if ((this.nodeMap & bitpos) != 0) {
            return this.nodeAt(bitpos).findByKey(key, keyHash, shift + 5);
        }
        if ((this.dataMap & bitpos) != 0 && Objects.equals(this.getKey(index = this.dataIndex(bitpos)), key)) {
            return this.getValue(index);
        }
        return NO_DATA;
    }

    @Override
    Object @NonNull [] getDataEntry(int index) {
        Object[] entry = new Object[2];
        System.arraycopy(this.mixed, 2 * index, entry, 0, 2);
        return entry;
    }

    @Override
    public @NonNull K getKey(int index) {
        return (K)this.mixed[2 * index];
    }

    @Override
    @NonNull EditableMapEntry<K, V> getMapEntry(int index) {
        return new EditableMapEntry<Object, Object>(this.mixed[2 * index], this.mixed[2 * index + 1], 0);
    }

    @Override
    @NonNull Node<K, V> getNode(int index) {
        return (Node)this.mixed[this.mixed.length - 1 - index];
    }

    @Override
    public @Nullable V getValue(int index) {
        return (V)this.mixed[2 * index + 1];
    }

    @Override
    boolean hasData() {
        return this.dataMap != 0;
    }

    @Override
    boolean hasDataArityOne() {
        return Integer.bitCount(this.dataMap) == 1;
    }

    @Override
    boolean hasNodes() {
        return this.nodeMap != 0;
    }

    @Override
    int nodeArity() {
        return Integer.bitCount(this.nodeMap);
    }

    @NonNull Node<K, V> nodeAt(int bitpos) {
        return (Node)this.mixed[this.mixed.length - 1 - this.nodeIndex(bitpos)];
    }

    int nodeIndex(int bitpos) {
        return Integer.bitCount(this.nodeMap & bitpos - 1);
    }

    int nodeIndex(int keyHash, int shift) {
        int mask = BitmapIndexedNode.mask(keyHash, shift);
        int bitpos = BitmapIndexedNode.bitpos(mask);
        return (this.nodeMap & bitpos) != 0 ? BitmapIndexedNode.index(this.nodeMap, bitpos) : -1;
    }

    public int nodeMap() {
        return this.nodeMap;
    }

    @Override
    public @NonNull BitmapIndexedNode<K, V> remove(@Nullable IdentityObject mutator, K key, int keyHash, int shift, @NonNull ChangeEvent<V> details) {
        int mask = BitmapIndexedNode.mask(keyHash, shift);
        int bitpos = BitmapIndexedNode.bitpos(mask);
        if ((this.dataMap & bitpos) != 0) {
            return this.removeData(mutator, key, keyHash, shift, details, bitpos);
        }
        if ((this.nodeMap & bitpos) != 0) {
            return this.removeSubNode(mutator, key, keyHash, shift, details, bitpos);
        }
        return this;
    }

    private @NonNull BitmapIndexedNode<K, V> removeData(@Nullable IdentityObject mutator, K key, int keyHash, int shift, @NonNull ChangeEvent<V> details, int bitpos) {
        int dataIndex = this.dataIndex(bitpos);
        if (!Objects.equals(this.getKey(dataIndex), key)) {
            return this;
        }
        V currentVal = this.getValue(dataIndex);
        details.updated(currentVal);
        if (this.dataArity() == 2 && !this.hasNodes()) {
            int newDataMap = shift == 0 ? this.dataMap ^ bitpos : BitmapIndexedNode.bitpos(BitmapIndexedNode.mask(keyHash, 0));
            Object[] nodes = this.getDataEntry(dataIndex ^ 1);
            return ChampTrie.newBitmapIndexedNode(mutator, 0, newDataMap, nodes);
        }
        int idx = dataIndex * 2;
        Object[] dst = ArrayHelper.copyComponentRemove(this.mixed, idx, 2);
        return ChampTrie.newBitmapIndexedNode(mutator, this.nodeMap, this.dataMap ^ bitpos, dst);
    }

    private @NonNull BitmapIndexedNode<K, V> removeSubNode(@Nullable IdentityObject mutator, K key, int keyHash, int shift, @NonNull ChangeEvent<V> details, int bitpos) {
        Node<K, V> subNodeNew;
        Node<K, V> subNode = this.nodeAt(bitpos);
        if (subNode == (subNodeNew = subNode.remove(mutator, key, keyHash, shift + 5, details))) {
            return this;
        }
        if (!subNodeNew.hasNodes() && subNodeNew.hasDataArityOne()) {
            if (!this.hasData() && this.nodeArity() == 1) {
                return (BitmapIndexedNode)subNodeNew;
            }
            return this.copyAndMigrateFromNodeToData(mutator, bitpos, subNodeNew);
        }
        return this.copyAndSetNode(mutator, bitpos, subNodeNew);
    }

    @Override
    public @NonNull BitmapIndexedNode<K, V> put(@Nullable IdentityObject mutator, K key, V val, int keyHash, int shift, @NonNull ChangeEvent<V> details, @NonNull ToIntFunction<K> hashFunction) {
        int mask = BitmapIndexedNode.mask(keyHash, shift);
        int bitpos = BitmapIndexedNode.bitpos(mask);
        if ((this.dataMap & bitpos) != 0) {
            int dataIndex = this.dataIndex(bitpos);
            K currentKey = this.getKey(dataIndex);
            V currentVal = this.getValue(dataIndex);
            if (Objects.equals(currentKey, key)) {
                if (Objects.equals(currentVal, val)) {
                    details.found(currentVal);
                    return this;
                }
                details.updated(currentVal);
                return this.copyAndSetValue(mutator, bitpos, val);
            }
            Node<K, V> subNodeNew = this.mergeTwoDataEntriesIntoNode(mutator, currentKey, currentVal, hashFunction.applyAsInt(currentKey), key, val, keyHash, shift + 5);
            details.modified();
            return this.copyAndMigrateFromDataToNode(mutator, bitpos, subNodeNew);
        }
        if ((this.nodeMap & bitpos) != 0) {
            Node<K, V> subNode = this.nodeAt(bitpos);
            Node<K, V> subNodeNew = subNode.put(mutator, key, val, keyHash, shift + 5, details, hashFunction);
            if (details.isModified()) {
                return this.copyAndSetNode(mutator, bitpos, subNodeNew);
            }
            return this;
        }
        details.modified();
        return this.copyAndInsertValue(mutator, bitpos, key, val);
    }
}

