/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champmap;

import java.util.Objects;
import java.util.function.ToIntFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.ArrayHelper;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champmap.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champmap.ChampTrie;
import org.jhotdraw8.icollection.impl.champmap.ChangeEvent;
import org.jhotdraw8.icollection.impl.champmap.EditableMapEntry;
import org.jhotdraw8.icollection.impl.champmap.Node;

class HashCollisionNode<K, V>
extends Node<K, V> {
    private final int hash;
    @NonNull Object[] entries;

    HashCollisionNode(int hash, Object @NonNull [] entries) {
        this.entries = entries;
        this.hash = hash;
    }

    @Override
    int dataArity() {
        return this.entries.length / 2;
    }

    @Override
    boolean hasDataArityOne() {
        return false;
    }

    @Override
    boolean equivalent(@NonNull Object other) {
        if (this == other) {
            return true;
        }
        HashCollisionNode that = (HashCollisionNode)other;
        @NonNull Object[] thatEntries = that.entries;
        if (this.hash != that.hash || thatEntries.length != this.entries.length) {
            return false;
        }
        @NonNull Object[] thatEntriesCloned = (Object[])thatEntries.clone();
        int remainingLength = thatEntriesCloned.length;
        block0: for (int i = 0; i < this.entries.length; i += 2) {
            Object key = this.entries[i];
            for (int j = 0; j < remainingLength; j += 2) {
                Object todoKey = thatEntriesCloned[j];
                if (!Objects.equals(todoKey, key)) continue;
                for (int f = 1; f < 2; ++f) {
                    if (Objects.equals(thatEntriesCloned[j + f], this.entries[i + f])) continue;
                    return false;
                }
                System.arraycopy(thatEntriesCloned, remainingLength - 2, thatEntriesCloned, j, 2);
                remainingLength -= 2;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    @Nullable Object findByKey(K key, int keyHash, int shift) {
        for (int i = 0; i < this.entries.length; i += 2) {
            if (!Objects.equals(key, this.entries[i])) continue;
            return this.entries[i + 1];
        }
        return NO_DATA;
    }

    @Override
    Object @NonNull [] getDataEntry(int index) {
        Object[] entry = new Object[2];
        System.arraycopy(this.entries, 2 * index, entry, 0, 2);
        return entry;
    }

    @Override
    public @NonNull K getKey(int index) {
        return (K)this.entries[index * 2];
    }

    @Override
    @NonNull EditableMapEntry<K, V> getMapEntry(int index) {
        return new EditableMapEntry<Object, Object>(this.entries[index * 2], this.entries[index * 2 + 1], 0);
    }

    @Override
    @NonNull Node<K, V> getNode(int index) {
        throw new IllegalStateException("Is leaf node.");
    }

    @Override
    public @Nullable V getValue(int index) {
        return (V)this.entries[index * 2 + 1];
    }

    @Override
    boolean hasData() {
        return true;
    }

    @Override
    boolean hasNodes() {
        return false;
    }

    @Override
    int nodeArity() {
        return 0;
    }

    @Override
    @Nullable Node<K, V> remove(@Nullable IdentityObject mutator, K key, int keyHash, int shift, @NonNull ChangeEvent<V> details) {
        int idx = 0;
        int i = 0;
        while (i < this.entries.length) {
            if (Objects.equals(this.entries[i], key)) {
                Object currentVal = this.entries[i + 1];
                details.updated(currentVal);
                if (this.entries.length == 2) {
                    return BitmapIndexedNode.emptyNode();
                }
                if (this.entries.length == 4) {
                    Object[] theOtherEntry = this.getDataEntry(idx ^ 1);
                    return ChampTrie.newBitmapIndexedNode(mutator, 0, HashCollisionNode.bitpos(HashCollisionNode.mask(keyHash, 0)), theOtherEntry);
                }
                Object[] entriesNew = ArrayHelper.copyComponentRemove(this.entries, idx * 2, 2);
                if (this.isAllowedToEdit(mutator)) {
                    this.entries = entriesNew;
                    return this;
                }
                return ChampTrie.newHashCollisionNode(mutator, keyHash, entriesNew, 2);
            }
            i += 2;
            ++idx;
        }
        return this;
    }

    @Override
    @Nullable Node<K, V> put(@Nullable IdentityObject mutator, K key, V val, int keyHash, int shift, @NonNull ChangeEvent<V> details, @NonNull ToIntFunction<K> hashFunction) {
        assert (this.hash == keyHash);
        int idx = 0;
        int i = 0;
        while (i < this.entries.length) {
            if (Objects.equals(this.entries[i], key)) {
                Object currentVal = this.entries[i + 1];
                if (Objects.equals(currentVal, val)) {
                    details.found(currentVal);
                    return this;
                }
                details.updated(currentVal);
                if (this.isAllowedToEdit(mutator)) {
                    this.entries[i + 1] = val;
                    return this;
                }
                Object[] dst = ArrayHelper.copySet(this.entries, i + 1, val);
                return ChampTrie.newHashCollisionNode(mutator, this.hash, dst, 2);
            }
            i += 2;
            ++idx;
        }
        Object[] entriesNew = ArrayHelper.copyComponentAdd(this.entries, this.entries.length, 2);
        entriesNew[this.entries.length] = key;
        entriesNew[this.entries.length + 1] = val;
        details.modified();
        if (this.isAllowedToEdit(mutator)) {
            this.entries = entriesNew;
            return this;
        }
        return ChampTrie.newHashCollisionNode(mutator, keyHash, entriesNew, 2);
    }
}

