/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champmap;

import java.util.Objects;
import java.util.function.ToIntFunction;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champmap.ChampTrie;
import org.jhotdraw8.icollection.impl.champmap.ChangeEvent;
import org.jhotdraw8.icollection.impl.champmap.EditableMapEntry;

public abstract class Node<K, V> {
    static final int HASH_CODE_LENGTH = 32;
    static final int BIT_PARTITION_SIZE = 5;
    static final int BIT_PARTITION_MASK = 31;
    public static final Object NO_DATA = new IdentityObject();
    static final int MAX_DEPTH = 8;
    static final int ENTRY_LENGTH = 2;

    Node() {
    }

    static int bitpos(int mask) {
        return 1 << mask;
    }

    static int index(int bitmap, int bitpos) {
        return Integer.bitCount(bitmap & bitpos - 1);
    }

    static int mask(int keyHash, int shift) {
        return keyHash >>> shift & 0x1F;
    }

    @NonNull Node<K, V> mergeTwoDataEntriesIntoNode(IdentityObject mutator, K k0, V v0, int keyHash0, K k1, V v1, int keyHash1, int shift) {
        int mask1;
        assert (!Objects.equals(k0, k1));
        if (shift >= 32) {
            Object[] entries = new Object[4];
            entries[0] = k0;
            entries[2] = k1;
            entries[1] = v0;
            entries[3] = v1;
            return ChampTrie.newHashCollisionNode(mutator, keyHash0, entries, 2);
        }
        int mask0 = Node.mask(keyHash0, shift);
        if (mask0 != (mask1 = Node.mask(keyHash1, shift))) {
            int dataMap = Node.bitpos(mask0) | Node.bitpos(mask1);
            Object[] entries = new Object[4];
            if (mask0 < mask1) {
                entries[0] = k0;
                entries[2] = k1;
                entries[1] = v0;
                entries[3] = v1;
            } else {
                entries[0] = k1;
                entries[2] = k0;
                entries[1] = v1;
                entries[3] = v0;
            }
            return ChampTrie.newBitmapIndexedNode(mutator, 0, dataMap, entries);
        }
        Node<K, V> node = this.mergeTwoDataEntriesIntoNode(mutator, k0, v0, keyHash0, k1, v1, keyHash1, shift + 5);
        int nodeMap = Node.bitpos(mask0);
        return ChampTrie.newBitmapIndexedNode(mutator, nodeMap, 0, new Object[]{node});
    }

    abstract int dataArity();

    abstract boolean hasDataArityOne();

    abstract boolean equivalent(@NonNull Object var1);

    abstract Object findByKey(K var1, int var2, int var3);

    abstract Object[] getDataEntry(int var1);

    public abstract K getKey(int var1);

    abstract EditableMapEntry<K, V> getMapEntry(int var1);

    @Nullable IdentityObject getMutator() {
        return null;
    }

    abstract Node<K, V> getNode(int var1);

    public abstract V getValue(int var1);

    abstract boolean hasData();

    abstract boolean hasNodes();

    boolean isAllowedToEdit(@Nullable IdentityObject y) {
        IdentityObject x = this.getMutator();
        return x != null && x == y;
    }

    abstract int nodeArity();

    abstract Node<K, V> remove(@Nullable IdentityObject var1, K var2, int var3, int var4, ChangeEvent<V> var5);

    abstract Node<K, V> put(@Nullable IdentityObject var1, K var2, V var3, int var4, int var5, ChangeEvent<V> var6, @NonNull ToIntFunction<K> var7);
}

