/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.iteration;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class FailFastSpliterator<E>
extends Spliterators.AbstractSpliterator<E> {
    private final @NonNull Spliterator<? extends E> s;
    private final int expectedModCount;
    private final @NonNull IntSupplier modCountSupplier;
    private final @Nullable Comparator<E> comparator;

    public FailFastSpliterator(@NonNull Spliterator<? extends E> s, @NonNull IntSupplier modCountSupplier, @Nullable Comparator<E> comparator) {
        super(s.estimateSize(), s.characteristics());
        this.s = s;
        this.modCountSupplier = modCountSupplier;
        this.expectedModCount = modCountSupplier.getAsInt();
        this.comparator = comparator;
    }

    @Override
    public boolean tryAdvance(@NonNull Consumer<? super E> action) {
        this.ensureUnmodified();
        return this.s.tryAdvance(action);
    }

    protected void ensureUnmodified() {
        if (this.expectedModCount != this.modCountSupplier.getAsInt()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public @Nullable Spliterator<E> trySplit() {
        Spliterator<? extends E> split = this.s.trySplit();
        return split == null ? null : new FailFastSpliterator<E>(split, this.modCountSupplier, null);
    }

    @Override
    public long estimateSize() {
        return this.s.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.s.characteristics() & 0xFFFFFBFF;
    }

    @Override
    public Comparator<? super E> getComparator() {
        if (this.s.hasCharacteristics(4)) {
            return this.comparator;
        }
        throw new IllegalStateException();
    }
}

