/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.iteration;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class MappedSpliterator<E, F>
implements Spliterator<E> {
    private final @NonNull Spliterator<? extends F> s;
    private final @NonNull Function<F, E> mappingFunction;
    private final int characteristics;
    private final @Nullable Comparator<? super E> comparator;

    public MappedSpliterator(@NonNull Spliterator<? extends F> s, @NonNull Function<F, E> mappingFunction, int characteristics, @Nullable Comparator<? super E> comparator) {
        this.s = s;
        this.mappingFunction = mappingFunction;
        this.characteristics = characteristics;
        this.comparator = comparator;
    }

    @Override
    public boolean tryAdvance(@NonNull Consumer<? super E> action) {
        return this.s.tryAdvance((? super T k) -> action.accept((E)this.mappingFunction.apply(k)));
    }

    @Override
    public @Nullable Spliterator<E> trySplit() {
        Spliterator<? extends F> split = this.s.trySplit();
        return split == null ? null : new MappedSpliterator<E, F>(split, this.mappingFunction, this.characteristics, this.comparator);
    }

    @Override
    public long estimateSize() {
        return this.s.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public @Nullable Comparator<? super E> getComparator() {
        return this.comparator;
    }
}

