/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.navigable;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.IntSupplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.navigable.DescendingNavigableSetView;

public class DescendingNavigableMapView<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V> {
    private final @NonNull NavigableMap<K, V> src;
    private final @NonNull IntSupplier modCount;

    public DescendingNavigableMapView(@NonNull NavigableMap<K, V> src, @NonNull IntSupplier modCount) {
        this.src = src;
        this.modCount = modCount;
    }

    @Override
    public boolean equals(Object o) {
        return this.src.equals(o);
    }

    @Override
    public int hashCode() {
        return this.src.hashCode();
    }

    @Override
    public int size() {
        return this.src.size();
    }

    @Override
    public boolean isEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.src.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.src.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.src.get(key);
    }

    @Override
    public V remove(Object key) {
        return this.src.remove(key);
    }

    @Override
    public @NonNull Set<Map.Entry<K, V>> entrySet() {
        return this.src.sequencedEntrySet().reversed();
    }

    @Override
    public @Nullable V put(K key, V value) {
        if (this.src.containsKey(key)) {
            return this.src.put(key, value);
        }
        this.src.putFirst(key, value);
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.src.remove(key, value);
    }

    @Override
    public void clear() {
        this.src.clear();
    }

    @Override
    public @NonNull Set<K> keySet() {
        return this.src.sequencedKeySet().reversed();
    }

    @Override
    public @NonNull Collection<V> values() {
        return this.src.sequencedValues().reversed();
    }

    @Override
    public @NonNull NavigableMap<K, V> reversed() {
        return this.src;
    }

    @Override
    public @NonNull SequencedSet<K> sequencedKeySet() {
        return this.src.sequencedKeySet().reversed();
    }

    @Override
    public @NonNull SequencedCollection<V> sequencedValues() {
        return this.src.sequencedValues().reversed();
    }

    @Override
    public @NonNull SequencedSet<Map.Entry<K, V>> sequencedEntrySet() {
        return this.src.sequencedEntrySet().reversed();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.src.higherEntry(key);
    }

    @Override
    public K lowerKey(K key) {
        return this.src.higherKey(key);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.src.ceilingEntry(key);
    }

    @Override
    public K floorKey(K key) {
        return this.src.ceilingKey(key);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.src.floorEntry(key);
    }

    @Override
    public K ceilingKey(K key) {
        return this.src.floorKey(key);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.src.lowerEntry(key);
    }

    @Override
    public K higherKey(K key) {
        return this.src.lowerKey(key);
    }

    @Override
    public  @Nullable Map.Entry<K, V> firstEntry() {
        return this.src.lastEntry();
    }

    @Override
    public  @Nullable Map.Entry<K, V> lastEntry() {
        return this.src.firstEntry();
    }

    @Override
    public  @Nullable Map.Entry<K, V> pollFirstEntry() {
        return this.src.pollLastEntry();
    }

    @Override
    public  @Nullable Map.Entry<K, V> pollLastEntry() {
        return this.src.pollFirstEntry();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return this.src;
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new DescendingNavigableSetView<K>(this.src.navigableKeySet(), this.modCount);
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return new DescendingNavigableSetView<K>(this.src.navigableKeySet(), this.modCount);
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.src.comparator().reversed();
    }

    @Override
    public @NonNull SortedMap<K, V> subMap(K fromKey, K toKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull SortedMap<K, V> headMap(K toKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull SortedMap<K, V> tailMap(K fromKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public K firstKey() {
        return this.src.lastKey();
    }

    @Override
    public K lastKey() {
        return this.src.firstKey();
    }

    @Override
    public @Nullable V putFirst(K k, V v) {
        return this.src.putLast(k, v);
    }

    @Override
    public @Nullable V putLast(K k, V v) {
        return this.src.putFirst(k, v);
    }
}

