/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.navigable;

import java.util.AbstractSet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.function.IntSupplier;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.navigable.DescendingNavigableSetView;

public class SubsetNavigableSetView<E>
extends AbstractSet<E>
implements NavigableSet<E> {
    private final @NonNull NavigableSet<E> src;
    private final @NonNull IntSupplier modCount;
    private final boolean fromStart;
    private final @Nullable E fromElement;
    private final boolean fromInclusive;
    private final boolean toEnd;
    private final @Nullable E toElement;
    private final boolean toInclusive;
    private final boolean nullFirst;

    public SubsetNavigableSetView(@NonNull NavigableSet<E> src, @NonNull IntSupplier modCount, boolean fromStart, @Nullable E fromElement, boolean fromInclusive, boolean toEnd, @Nullable E toElement, boolean toInclusive, boolean nullFirst) {
        this.src = src;
        this.modCount = modCount;
        this.fromStart = fromStart;
        this.fromElement = fromElement;
        this.fromInclusive = fromInclusive;
        this.toEnd = toEnd;
        this.toElement = toElement;
        this.toInclusive = toInclusive;
        this.nullFirst = nullFirst;
    }

    private int compare(@Nullable E a, @Nullable E b) {
        Comparator comparator = this.src.comparator();
        if (comparator == null) {
            if (a == null) {
                return b == null ? 0 : (this.nullFirst ? -1 : 1);
            }
            if (b == null) {
                return this.nullFirst ? 1 : -1;
            }
            return ((Comparable)a).compareTo(b);
        }
        return comparator.compare(a, b);
    }

    private boolean tooLow(@Nullable E key) {
        int c;
        return !this.fromStart && ((c = this.compare(key, this.fromElement)) < 0 || c == 0 && !this.fromInclusive);
    }

    private boolean tooHigh(@Nullable E key) {
        int c;
        return !this.toEnd && ((c = this.compare(key, this.toElement)) > 0 || c == 0 && !this.toInclusive);
    }

    private @Nullable E lowest() {
        Object e = this.fromStart ? this.src.first() : (this.fromInclusive ? this.src.ceiling(this.fromElement) : this.src.higher(this.fromElement));
        return e == null || this.tooHigh(e) ? null : (E)e;
    }

    private @Nullable E highest() {
        Object e = this.toEnd ? this.src.last() : (this.toInclusive ? this.src.floor(this.toElement) : this.src.lower(this.toElement));
        return e == null || this.tooLow(e) ? null : (E)e;
    }

    @Override
    public @Nullable E lower(E e) {
        if (this.tooHigh(e)) {
            return this.highest();
        }
        return (e = this.src.lower(e)) == null || this.tooLow(e) ? null : (E)e;
    }

    @Override
    public @Nullable E floor(E e) {
        if (this.tooHigh(e)) {
            return this.highest();
        }
        return (e = this.src.floor(e)) == null || this.tooLow(e) ? null : (E)e;
    }

    @Override
    public @Nullable E ceiling(E e) {
        if (this.tooLow(e)) {
            return this.lowest();
        }
        return (e = this.src.ceiling(e)) == null || this.tooHigh(e) ? null : (E)e;
    }

    @Override
    public @Nullable E higher(E e) {
        if (this.tooLow(e)) {
            return this.lowest();
        }
        return (e = this.src.higher(e)) == null || this.tooHigh(e) ? null : (E)e;
    }

    @Override
    public @Nullable E pollFirst() {
        return this.lowest();
    }

    @Override
    public @Nullable E pollLast() {
        return this.highest();
    }

    @Override
    public int size() {
        return this.fromStart && this.toEnd ? this.src.size() : this.countElements();
    }

    private int countElements() {
        int size = 0;
        for (E e : this) {
            ++size;
        }
        return size;
    }

    private boolean inRange(Object key) {
        return !this.tooLow(key) && !this.tooHigh(key);
    }

    private @Nullable E iteratorHighFence() {
        return this.toEnd ? null : (this.toInclusive ? (E)this.src.higher(this.toElement) : (E)this.src.ceiling(this.toElement));
    }

    private @Nullable E iteratorLowFence() {
        return this.fromStart ? null : (this.fromInclusive ? (E)this.src.lower(this.fromElement) : (E)this.src.floor(this.fromElement));
    }

    @Override
    public boolean contains(Object o) {
        return this.inRange(o) && this.src.contains(o);
    }

    @Override
    public @NonNull Iterator<E> iterator() {
        return new SubsetIterator(this.lowest(), this.iteratorHighFence(), this.src.iterator());
    }

    @Override
    public boolean add(E e) {
        if (!this.inRange(e)) {
            throw new IllegalArgumentException("element out of range");
        }
        return this.src.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.inRange(o) && this.src.remove(o);
    }

    @Override
    public void clear() {
        if (this.fromStart && this.toEnd) {
            this.src.clear();
        } else {
            for (Object o : this.toArray()) {
                this.src.remove(o);
            }
        }
    }

    @Override
    public @NonNull NavigableSet<E> descendingSet() {
        return new DescendingNavigableSetView(this, this.modCount);
    }

    @Override
    public @NonNull Iterator<E> descendingIterator() {
        return new SubsetIterator(this.highest(), this.iteratorLowFence(), this.src.descendingIterator());
    }

    private boolean inClosedRange(E e) {
        return !(!this.fromStart && this.compare(e, this.fromElement) < 0 || !this.toEnd && this.compare(this.toElement, e) < 0);
    }

    private boolean inRange(E e, boolean inclusive) {
        return inclusive ? this.inRange(e) : this.inClosedRange(e);
    }

    @Override
    public @NonNull NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        if (!this.inRange(fromElement, fromInclusive)) {
            throw new IllegalArgumentException("fromElement out of range");
        }
        if (!this.inRange(toElement, toInclusive)) {
            throw new IllegalArgumentException("toElement out of range");
        }
        return new SubsetNavigableSetView<E>(this.src, this.modCount, false, fromElement, fromInclusive, false, toElement, toInclusive, this.nullFirst);
    }

    @Override
    public @NonNull NavigableSet<E> headSet(E toElement, boolean inclusive) {
        if (!this.inRange(toElement, this.toInclusive)) {
            throw new IllegalArgumentException("toElement out of range");
        }
        return new SubsetNavigableSetView<E>(this.src, this.modCount, this.fromStart, this.fromElement, this.fromInclusive, false, toElement, this.toInclusive, this.nullFirst);
    }

    @Override
    public @NonNull NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        if (!this.inRange(fromElement, this.fromInclusive)) {
            throw new IllegalArgumentException("fromElement out of range");
        }
        return new SubsetNavigableSetView<E>(this.src, this.modCount, false, fromElement, this.fromInclusive, this.toEnd, this.toElement, this.toInclusive, this.nullFirst);
    }

    @Override
    public @Nullable Comparator<? super E> comparator() {
        return this.src.comparator();
    }

    @Override
    public @NonNull SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public @NonNull SortedSet<E> headSet(E toElement) {
        return this.headSet(this.fromElement, false);
    }

    @Override
    public @NonNull SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public E first() {
        return this.lowest();
    }

    @Override
    public E last() {
        return this.highest();
    }

    private class SubsetIterator
    implements Iterator<E> {
        boolean hasLastReturned;
        E lastReturned;
        E next;
        boolean hasNext;
        final Object fenceKey;
        int expectedModCount;
        Iterator<E> srcIterator;

        SubsetIterator(@Nullable E first, E fence, Iterator<E> srcIterator) {
            this.expectedModCount = SubsetNavigableSetView.this.modCount.getAsInt();
            this.lastReturned = null;
            if (first == null) {
                this.hasNext = srcIterator.hasNext();
                this.next = srcIterator.next();
            } else {
                while (srcIterator.hasNext()) {
                    this.next = srcIterator.next();
                    if (this.next != first) continue;
                    this.hasNext = true;
                    break;
                }
            }
            Object object = this.fenceKey = fence == null ? new IdentityObject() : fence;
            if (this.next == this.fenceKey) {
                this.hasNext = false;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public final E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (SubsetNavigableSetView.this.modCount.getAsInt() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object e = this.next;
            this.hasNext = this.srcIterator.hasNext();
            if (this.hasNext) {
                this.next = this.srcIterator.next();
                if (this.next == this.fenceKey) {
                    this.hasNext = false;
                }
            }
            this.hasLastReturned = true;
            this.lastReturned = e;
            return e;
        }

        @Override
        public void remove() {
            if (!this.hasLastReturned) {
                throw new IllegalStateException();
            }
            if (SubsetNavigableSetView.this.modCount.getAsInt() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SubsetNavigableSetView.this.src.remove(this.lastReturned);
            this.lastReturned = null;
            this.hasLastReturned = false;
            this.expectedModCount = SubsetNavigableSetView.this.modCount.getAsInt();
        }
    }
}

