/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import org.jhotdraw8.icollection.MutableChampVectorMap;
import org.jhotdraw8.icollection.PrivateData;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedMapFacade;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.immutable.ImmutableSequencedMap;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champ.AbstractMutableChampMap;
import org.jhotdraw8.icollection.impl.champ.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champ.ChangeEvent;
import org.jhotdraw8.icollection.impl.champ.Node;
import org.jhotdraw8.icollection.impl.champ.OrderedPair;
import org.jhotdraw8.icollection.impl.champ.ReverseTombSkippingVectorSpliterator;
import org.jhotdraw8.icollection.impl.champ.SequencedData;
import org.jhotdraw8.icollection.impl.champ.SequencedEntry;
import org.jhotdraw8.icollection.impl.champ.TombSkippingVectorSpliterator;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedMap;
import org.jhotdraw8.icollection.serialization.MapSerializationProxy;
import org.jspecify.annotations.Nullable;

public class ChampVectorMap<K, V>
implements ImmutableSequencedMap<K, V>,
Serializable {
    private static final ChampVectorMap<?, ?> EMPTY = new ChampVectorMap(BitmapIndexedNode.emptyNode(), VectorList.of(), 0, 0);
    private static final long serialVersionUID = 0L;
    final transient BitmapIndexedNode<SequencedEntry<K, V>> root;
    final int offset;
    final int size;
    final VectorList<Object> vector;

    protected ChampVectorMap(PrivateData privateData) {
        this(((OpaqueRecord)privateData.get()).root, ((OpaqueRecord)privateData.get()).vector, ((OpaqueRecord)privateData.get()).size, ((OpaqueRecord)privateData.get()).offset);
    }

    protected ChampVectorMap<K, V> newInstance(PrivateData privateData) {
        return new ChampVectorMap<K, V>(privateData);
    }

    private ChampVectorMap<K, V> newInstance(BitmapIndexedNode<SequencedEntry<K, V>> root, VectorList<Object> vector, int size, int offset) {
        return new ChampVectorMap<K, V>(new PrivateData(new OpaqueRecord<K, V>(root, vector, size, offset)));
    }

    ChampVectorMap(BitmapIndexedNode<SequencedEntry<K, V>> root, VectorList<Object> vector, int size, int offset) {
        this.root = root;
        this.size = size;
        this.offset = offset;
        this.vector = Objects.requireNonNull(vector);
    }

    public static <K, V> ChampVectorMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> map) {
        return ChampVectorMap.of().putAll(map);
    }

    public static <K, V> ChampVectorMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        return ChampVectorMap.of().putAll((Map)map);
    }

    public static <K, V> ChampVectorMap<K, V> of() {
        return EMPTY;
    }

    @Override
    public ChampVectorMap<K, V> clear() {
        return this.isEmpty() ? this : ChampVectorMap.of();
    }

    @Override
    public boolean containsKey(@Nullable Object o) {
        Object key = o;
        return this.root.find(new SequencedEntry(key), SequencedEntry.keyHash(key), 0, SequencedEntry::keyEquals) != Node.NO_DATA;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ChampVectorMap) {
            ChampVectorMap that = (ChampVectorMap)other;
            return this.size == that.size && this.root.equivalent(that.root);
        }
        return ReadOnlyMap.mapEquals(this, other);
    }

    @Override
    public @Nullable Map.Entry<K, V> firstEntry() {
        return this.isEmpty() ? null : (Map.Entry)this.vector.getFirst();
    }

    @Override
    public @Nullable Map.Entry<K, V> lastEntry() {
        return this.isEmpty() ? null : (Map.Entry)this.vector.getLast();
    }

    @Override
    public @Nullable V get(Object o) {
        V v;
        Object result = this.root.find(new SequencedEntry(o), SequencedEntry.keyHash(o), 0, SequencedEntry::keyEquals);
        if (result instanceof SequencedEntry) {
            SequencedEntry entry = (SequencedEntry)result;
            v = entry.getValue();
        } else {
            v = null;
        }
        return v;
    }

    @Override
    public int hashCode() {
        return ReadOnlyMap.iteratorToHashCode(this.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public int maxSize() {
        return 0x40000000;
    }

    @Override
    public ChampVectorMap<K, V> put(K key, @Nullable V value) {
        return this.putLast(key, value, false);
    }

    @Override
    public ChampVectorMap<K, V> putAll(Map<? extends K, ? extends V> m) {
        return (ChampVectorMap)ImmutableSequencedMap.super.putAll(m);
    }

    @Override
    public ChampVectorMap<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        Map m = this.toMutable();
        return ((MutableChampVectorMap)m).putAll(c) ? ((MutableChampVectorMap)m).toImmutable() : this;
    }

    @Override
    public ChampVectorMap<K, V> putFirst(K key, @Nullable V value) {
        return this.putFirst(key, value, true);
    }

    private ChampVectorMap<K, V> putFirst(K key, @Nullable V value, boolean moveToFirst) {
        ChangeEvent details = new ChangeEvent();
        SequencedEntry<K, V> newEntry = new SequencedEntry<K, V>(key, value, -this.offset - 1);
        Node newRoot = this.root.put(null, (Object)newEntry, SequencedEntry.keyHash(key), 0, details, moveToFirst ? SequencedEntry::updateAndMoveToFirst : SequencedEntry::update, SequencedEntry::keyEquals, SequencedEntry::entryKeyHash);
        if (details.isReplaced() && ((SequencedEntry)details.getOldDataNonNull()).getSequenceNumber() == ((SequencedEntry)details.getNewDataNonNull()).getSequenceNumber()) {
            ImmutableList newVector = this.vector.set(((SequencedEntry)details.getNewDataNonNull()).getSequenceNumber() - this.offset, details.getNewDataNonNull());
            return this.newInstance((BitmapIndexedNode<SequencedEntry<K, V>>)newRoot, (VectorList<Object>)newVector, this.size, this.offset);
        }
        if (details.isModified()) {
            ImmutableList<Object> newVector = this.vector;
            int newSize = this.size;
            if (details.isReplaced()) {
                if (moveToFirst) {
                    OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(newVector, (SequencedEntry)details.getOldDataNonNull(), this.offset);
                    newVector = result.first();
                }
            } else {
                ++newSize;
            }
            int newOffset = this.offset + 1;
            newVector = newVector.addFirst((Object)newEntry);
            return this.renumber((BitmapIndexedNode<SequencedEntry<K, V>>)newRoot, (VectorList<Object>)newVector, newSize, newOffset);
        }
        return this;
    }

    private ChampVectorMap<K, V> putLast(K key, @Nullable V value, boolean moveToLast) {
        ChangeEvent details = new ChangeEvent();
        SequencedEntry<K, V> newEntry = new SequencedEntry<K, V>(key, value, this.vector.size() - this.offset);
        Node newRoot = this.root.put(null, (Object)newEntry, SequencedEntry.keyHash(key), 0, details, moveToLast ? SequencedEntry::updateAndMoveToLast : SequencedEntry::update, SequencedEntry::keyEquals, SequencedEntry::entryKeyHash);
        if (details.isReplaced() && ((SequencedEntry)details.getOldDataNonNull()).getSequenceNumber() == ((SequencedEntry)details.getNewDataNonNull()).getSequenceNumber()) {
            ImmutableList newVector = this.vector.set(((SequencedEntry)details.getNewDataNonNull()).getSequenceNumber() - this.offset, details.getNewDataNonNull());
            return this.newInstance((BitmapIndexedNode<SequencedEntry<K, V>>)newRoot, (VectorList<Object>)newVector, this.size, this.offset);
        }
        if (details.isModified()) {
            ImmutableList<Object> newVector = this.vector;
            int newOffset = this.offset;
            int newSize = this.size;
            if (details.isReplaced()) {
                if (moveToLast) {
                    SequencedEntry oldElem = (SequencedEntry)details.getOldDataNonNull();
                    OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(newVector, oldElem, newOffset);
                    newVector = result.first();
                    newOffset = result.second();
                }
            } else {
                ++newSize;
            }
            newVector = newVector.addLast((Object)newEntry);
            return this.renumber((BitmapIndexedNode<SequencedEntry<K, V>>)newRoot, (VectorList<Object>)newVector, newSize, newOffset);
        }
        return this;
    }

    @Override
    public ChampVectorMap<K, V> putLast(K key, @Nullable V value) {
        return this.putLast(key, value, true);
    }

    @Override
    public ReadOnlySequencedMap<K, V> readOnlyReversed() {
        return new ReadOnlySequencedMapFacade<Object, Object>(this::reverseIterator, this::iterator, this::size, this::containsKey, this::get, this::lastEntry, this::firstEntry, 81, null);
    }

    @Override
    public ChampVectorMap<K, V> remove(K key) {
        int keyHash = SequencedEntry.keyHash(key);
        ChangeEvent details = new ChangeEvent();
        Node newRoot = this.root.remove(null, (Object)new SequencedEntry(key), keyHash, 0, details, SequencedEntry::keyEquals);
        if (details.isModified()) {
            SequencedEntry oldElem = (SequencedEntry)details.getOldDataNonNull();
            OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(this.vector, oldElem, this.offset);
            return this.size == 1 ? ChampVectorMap.of() : this.renumber((BitmapIndexedNode<SequencedEntry<K, V>>)newRoot, result.first(), this.size - 1, result.second());
        }
        return this;
    }

    @Override
    public ChampVectorMap<K, V> removeAll(Iterable<? extends K> c) {
        Map t = this.toMutable();
        return ((AbstractMutableChampMap)t).removeAll(c) ? ((MutableChampVectorMap)t).toImmutable() : this;
    }

    private ChampVectorMap<K, V> renumber(BitmapIndexedNode<SequencedEntry<K, V>> root, VectorList<Object> vector, int size, int offset) {
        if (SequencedData.vecMustRenumber(size, offset, this.vector.size())) {
            IdentityObject owner = new IdentityObject();
            OrderedPair<BitmapIndexedNode<SequencedEntry>, VectorList<Object>> result = SequencedData.vecRenumber(owner, size, vector.size(), root, vector.trie, SequencedEntry::entryKeyHash, SequencedEntry::keyEquals, (e, seq) -> new SequencedEntry(e.getKey(), e.getValue(), (int)seq));
            return this.newInstance(result.first(), result.second(), size, 0);
        }
        return this.newInstance(root, vector, size, offset);
    }

    @Override
    public ChampVectorMap<K, V> retainAll(Iterable<? extends K> c) {
        Map m = this.toMutable();
        return ((AbstractMutableChampMap)m).retainAll(c) ? ((MutableChampVectorMap)m).toImmutable() : this;
    }

    Iterator<Map.Entry<K, V>> reverseIterator() {
        return Spliterators.iterator(this.reverseSpliterator());
    }

    Spliterator<Map.Entry<K, V>> reverseSpliterator() {
        return new ReverseTombSkippingVectorSpliterator<Map.Entry<K, V>>(this.vector, e -> (SequencedEntry)e, this.size(), 0x100 | this.characteristics());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return new TombSkippingVectorSpliterator<Map.Entry<K, V>>(this.vector.trie, e -> (Map.Entry)e, 0, this.size(), this.vector.size(), 0x100 | this.characteristics());
    }

    @Override
    public MutableChampVectorMap<K, V> toMutable() {
        return new MutableChampVectorMap(this);
    }

    @Override
    public MutableChampVectorMap<K, V> asMap() {
        return new MutableChampVectorMap(this);
    }

    public String toString() {
        return ReadOnlyMap.mapToString(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.toMutable());
    }

    @Override
    public int characteristics() {
        return 1105;
    }

    private record OpaqueRecord<K, V>(BitmapIndexedNode<SequencedEntry<K, V>> root, VectorList<Object> vector, int size, int offset) {
    }

    private static class SerializationProxy<K, V>
    extends MapSerializationProxy<K, V> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(Map<K, V> target) {
            super(target);
        }

        @Override
        protected Object readResolve() {
            return ChampVectorMap.of().putAll((Iterable)this.deserializedEntries);
        }
    }
}

