/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.jhotdraw8.icollection.MutableChampVectorSet;
import org.jhotdraw8.icollection.PrivateData;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedSetFacade;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.immutable.ImmutableSequencedSet;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champ.AbstractMutableChampSet;
import org.jhotdraw8.icollection.impl.champ.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champ.ChangeEvent;
import org.jhotdraw8.icollection.impl.champ.Node;
import org.jhotdraw8.icollection.impl.champ.OrderedPair;
import org.jhotdraw8.icollection.impl.champ.ReverseTombSkippingVectorSpliterator;
import org.jhotdraw8.icollection.impl.champ.SequencedData;
import org.jhotdraw8.icollection.impl.champ.SequencedElement;
import org.jhotdraw8.icollection.impl.champ.TombSkippingVectorSpliterator;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedSet;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jhotdraw8.icollection.serialization.SetSerializationProxy;
import org.jspecify.annotations.Nullable;

public class ChampVectorSet<E>
implements Serializable,
ImmutableSequencedSet<E> {
    private static final ChampVectorSet<?> EMPTY = new ChampVectorSet(BitmapIndexedNode.emptyNode(), VectorList.of(), 0, 0);
    private static final long serialVersionUID = 0L;
    final transient BitmapIndexedNode<SequencedElement<E>> root;
    final int offset;
    final int size;
    final VectorList<Object> vector;

    protected ChampVectorSet(PrivateData privateData) {
        this(((OpaqueRecord)privateData.get()).root, ((OpaqueRecord)privateData.get()).vector, ((OpaqueRecord)privateData.get()).size, ((OpaqueRecord)privateData.get()).offset);
    }

    protected ChampVectorSet<E> newInstance(PrivateData privateData) {
        return new ChampVectorSet<E>(privateData);
    }

    private ChampVectorSet<E> newInstance(BitmapIndexedNode<SequencedElement<E>> root, VectorList<Object> vector, int size, int offset) {
        return new ChampVectorSet<E>(new PrivateData(new OpaqueRecord<E>(root, vector, size, offset)));
    }

    ChampVectorSet(BitmapIndexedNode<SequencedElement<E>> root, VectorList<Object> vector, int size, int offset) {
        this.root = root;
        this.size = size;
        this.offset = offset;
        this.vector = Objects.requireNonNull(vector);
    }

    public static <E> ChampVectorSet<E> copyOf(Iterable<? extends E> c) {
        return ChampVectorSet.of().addAll(c);
    }

    public static <E> ChampVectorSet<E> of() {
        return EMPTY;
    }

    @SafeVarargs
    public static <E> ChampVectorSet<E> of(E ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return ChampVectorSet.of().addAll((Iterable)Arrays.asList(elements));
    }

    @Override
    public ChampVectorSet<E> add(@Nullable E key) {
        return this.addLast(key, false);
    }

    @Override
    public ChampVectorSet<E> addAll(Iterable<? extends E> c) {
        SequencedSet m = this.toMutable();
        return ((AbstractMutableChampSet)((Object)m)).addAll(c) ? ((MutableChampVectorSet)m).toImmutable() : this;
    }

    @Override
    public ChampVectorSet<E> addFirst(@Nullable E element) {
        return this.addFirst(element, true);
    }

    private ChampVectorSet<E> addFirst(@Nullable E e, boolean moveToFirst) {
        ChangeEvent details = new ChangeEvent();
        SequencedElement<E> newElem = new SequencedElement<E>(e, -this.offset - 1);
        Node newRoot = this.root.put(null, (Object)newElem, SequencedElement.keyHash(e), 0, details, moveToFirst ? SequencedElement::putAndMoveToFirst : SequencedElement::put, Objects::equals, SequencedElement::elementKeyHash);
        if (details.isModified()) {
            ImmutableList<Object> newVector = this.vector;
            int newSize = this.size;
            if (details.isReplaced()) {
                if (moveToFirst) {
                    OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(newVector, (SequencedElement)details.getOldDataNonNull(), this.offset);
                    newVector = result.first();
                }
            } else {
                ++newSize;
            }
            int newOffset = this.offset + 1;
            newVector = newVector.addFirst((Object)newElem);
            return this.renumber((BitmapIndexedNode<SequencedElement<E>>)newRoot, (VectorList<Object>)newVector, newSize, newOffset);
        }
        return this;
    }

    @Override
    public ChampVectorSet<E> addLast(@Nullable E element) {
        return this.addLast(element, true);
    }

    private ChampVectorSet<E> addLast(@Nullable E e, boolean moveToLast) {
        ChangeEvent details = new ChangeEvent();
        SequencedElement<E> newElem = new SequencedElement<E>(e, this.vector.size() - this.offset);
        Node newRoot = this.root.put(null, (Object)newElem, SequencedElement.keyHash(e), 0, details, moveToLast ? SequencedElement::putAndMoveToLast : SequencedElement::put, Objects::equals, SequencedElement::elementKeyHash);
        if (details.isModified()) {
            ImmutableList<Object> newVector = this.vector;
            int newOffset = this.offset;
            int newSize = this.size;
            if (details.isReplaced()) {
                if (moveToLast) {
                    SequencedElement oldElem = (SequencedElement)details.getOldData();
                    OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(newVector, oldElem, newOffset);
                    newVector = result.first();
                    newOffset = result.second();
                }
            } else {
                ++newSize;
            }
            newVector = newVector.addLast((Object)newElem);
            return this.renumber((BitmapIndexedNode<SequencedElement<E>>)newRoot, (VectorList<Object>)newVector, newSize, newOffset);
        }
        return this;
    }

    @Override
    public <T> ChampVectorSet<T> empty() {
        return ChampVectorSet.of();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        Object key = o;
        return this.root.find(new SequencedElement<Object>(key), SequencedElement.keyHash(key), 0, Objects::equals) != Node.NO_DATA;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof ChampVectorSet) {
            ChampVectorSet that = (ChampVectorSet)other;
            return this.size == that.size && this.root.equivalent(that.root);
        }
        return ReadOnlySet.setEquals(this, other);
    }

    @Override
    public E getFirst() {
        return ((SequencedElement)this.vector.getFirst()).getElement();
    }

    @Override
    public E getLast() {
        return ((SequencedElement)this.vector.getLast()).getElement();
    }

    @Override
    public int hashCode() {
        return ReadOnlySet.iteratorToHashCode(this.iterator());
    }

    @Override
    public Iterator<E> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public int maxSize() {
        return 0x40000000;
    }

    @Override
    public ReadOnlySequencedSet<E> readOnlyReversed() {
        return new ReadOnlySequencedSetFacade<Object>(this::reverseIterator, this::iterator, this::size, this::contains, this::getLast, this::getFirst, 1024);
    }

    @Override
    public ChampVectorSet<E> remove(@Nullable E key) {
        int keyHash = SequencedElement.keyHash(key);
        ChangeEvent details = new ChangeEvent();
        Node newRoot = this.root.remove(null, (Object)new SequencedElement<E>(key), keyHash, 0, details, Objects::equals);
        if (details.isModified()) {
            SequencedElement removedElem = (SequencedElement)details.getOldDataNonNull();
            OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(this.vector, removedElem, this.offset);
            return this.size == 1 ? ChampVectorSet.of() : this.renumber((BitmapIndexedNode<SequencedElement<E>>)newRoot, result.first(), this.size - 1, result.second());
        }
        return this;
    }

    @Override
    public ChampVectorSet<E> removeAll(Iterable<?> c) {
        SequencedSet m = this.toMutable();
        return ((AbstractMutableChampSet)((Object)m)).removeAll(c) ? ((MutableChampVectorSet)m).toImmutable() : this;
    }

    @Override
    public ChampVectorSet<E> removeFirst() {
        return this.remove((Object)this.getFirst());
    }

    @Override
    public ChampVectorSet<E> removeLast() {
        return this.remove((Object)this.getLast());
    }

    private ChampVectorSet<E> renumber(BitmapIndexedNode<SequencedElement<E>> root, VectorList<Object> vector, int size, int offset) {
        if (SequencedData.vecMustRenumber(size, offset, this.vector.size())) {
            IdentityObject owner = new IdentityObject();
            OrderedPair<BitmapIndexedNode<SequencedElement>, VectorList<Object>> result = SequencedData.vecRenumber(new IdentityObject(), size, vector.size(), root, vector.trie, SequencedElement::elementKeyHash, Objects::equals, (e, seq) -> new SequencedElement(e.getElement(), (int)seq));
            return this.newInstance(result.first(), result.second(), size, 0);
        }
        return this.newInstance(root, vector, size, offset);
    }

    @Override
    public ChampVectorSet<E> retainAll(Iterable<?> c) {
        SequencedSet m = this.toMutable();
        return ((AbstractMutableChampSet)((Object)m)).retainAll(c) ? ((MutableChampVectorSet)m).toImmutable() : this;
    }

    Iterator<E> reverseIterator() {
        return Spliterators.iterator(this.reverseSpliterator());
    }

    Spliterator<E> reverseSpliterator() {
        return new ReverseTombSkippingVectorSpliterator<Object>(this.vector, e -> ((SequencedElement)e).getElement(), 1105L, this.size());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Spliterator<E> spliterator() {
        return new TombSkippingVectorSpliterator<Object>(this.vector.trie, e -> ((SequencedElement)e).getElement(), 0, this.size(), this.vector.size(), 1105);
    }

    @Override
    public MutableChampVectorSet<E> toMutable() {
        return new MutableChampVectorSet(this);
    }

    public String toString() {
        return ReadOnlyCollection.iterableToString(this);
    }

    private Object writeReplace() {
        return new SerializationProxy(this.toMutable());
    }

    private record OpaqueRecord<E>(BitmapIndexedNode<SequencedElement<E>> root, VectorList<Object> vector, int size, int offset) {
    }

    private static class SerializationProxy<E>
    extends SetSerializationProxy<E> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(Set<E> target) {
            super(target);
        }

        @Override
        protected Object readResolve() {
            return ChampVectorSet.copyOf(this.deserializedElements);
        }
    }
}

