/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.facade.SetFacade;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champmap.AbstractMutableChampMap;
import org.jhotdraw8.icollection.impl.champmap.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champmap.ChangeEvent;
import org.jhotdraw8.icollection.impl.champmap.EntryIterator;
import org.jhotdraw8.icollection.impl.champmap.Node;
import org.jhotdraw8.icollection.impl.iteration.FailFastIterator;
import org.jhotdraw8.icollection.impl.iteration.IteratorSpliterator;
import org.jhotdraw8.icollection.serialization.MapSerializationProxy;
import org.jspecify.annotations.Nullable;

public class MutableChampMap<K, V>
extends AbstractMutableChampMap<K, V> {
    private static final long serialVersionUID = 0L;

    public MutableChampMap() {
        this.root = BitmapIndexedNode.emptyNode();
    }

    public MutableChampMap(Map<? extends K, ? extends V> m) {
        if (m instanceof MutableChampMap) {
            MutableChampMap that = (MutableChampMap)m;
            this.root = that.root;
            this.size = that.size;
            this.modCount = 0;
        } else {
            this.root = BitmapIndexedNode.emptyNode();
            this.putAll(m);
        }
    }

    public MutableChampMap(Iterable<? extends Map.Entry<? extends K, ? extends V>> m) {
        if (m instanceof ChampMap) {
            ChampMap that = (ChampMap)m;
            this.root = that.root;
            this.size = that.size;
        } else {
            this.root = BitmapIndexedNode.emptyNode();
            for (Map.Entry<K, V> e : m) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.root = BitmapIndexedNode.emptyNode();
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public MutableChampMap<K, V> clone() {
        return (MutableChampMap)super.clone();
    }

    @Override
    public boolean containsKey(@Nullable Object o) {
        return this.root.findByKey(o, ChampMap.keyHash(o), 0) != Node.NO_DATA;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new FailFastIterator<Map.Entry<K, V>>(new EntryIterator<Object, Object>(this.root, this::iteratorRemoveKey, this::iteratorPutIfPresent), () -> this.getModCount());
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return new IteratorSpliterator<Map.Entry<K, V>>(this.iterator(), this.size(), 0x100 | this.characteristics(), null);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetFacade<Map.Entry<K, V>>(this::iterator, this::spliterator, this::size, this::containsEntry, this::clear, null, this::removeEntry);
    }

    @Override
    public @Nullable V get(Object o) {
        Object result = this.root.findByKey(o, ChampMap.keyHash(o), 0);
        return (V)(result == Node.NO_DATA ? null : result);
    }

    private void iteratorPutIfPresent(@Nullable K k, @Nullable V v) {
        if (this.containsKey(k)) {
            this.owner = null;
            this.put(k, v);
        }
    }

    @Override
    public @Nullable V put(K key, V value) {
        return this.putEntry(key, value).getOldValue();
    }

    ChangeEvent<V> putEntry(@Nullable K key, @Nullable V val) {
        int keyHash = ChampMap.keyHash(key);
        ChangeEvent details = new ChangeEvent();
        this.root = this.root.put(this.getOrCreateOwner(), (Object)key, (Object)val, keyHash, 0, details, ChampMap::keyHash);
        if (details.isModified() && !details.isReplaced()) {
            ++this.size;
            ++this.modCount;
        }
        return details;
    }

    @Override
    public V remove(Object o) {
        Object key = o;
        return this.removeKey(key).getOldValue();
    }

    @Override
    public boolean removeAll(Iterable<?> c) {
        return super.removeAll(c);
    }

    ChangeEvent<V> removeKey(K key) {
        int keyHash = ChampMap.keyHash(key);
        ChangeEvent details = new ChangeEvent();
        this.root = this.root.remove(this.getOrCreateOwner(), (Object)key, keyHash, 0, details);
        if (details.isModified()) {
            --this.size;
            ++this.modCount;
        }
        return details;
    }

    void iteratorRemoveKey(K key) {
        int keyHash = ChampMap.keyHash(key);
        ChangeEvent details = new ChangeEvent();
        this.root = this.root.remove((IdentityObject)null, (Object)key, keyHash, 0, details);
        if (details.isModified()) {
            --this.size;
            ++this.modCount;
        }
    }

    @Override
    protected boolean removeEntry(@Nullable Object o) {
        if (this.containsEntry(o)) {
            assert (o != null);
            Map.Entry entry = (Map.Entry)o;
            this.remove(entry.getKey());
            return true;
        }
        return false;
    }

    public ChampMap<K, V> toImmutable() {
        this.owner = null;
        return this.isEmpty() ? ChampMap.of() : new ChampMap(this.root, this.size);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy<K, V>
    extends MapSerializationProxy<K, V> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(Map<K, V> target) {
            super(target);
        }

        @Override
        protected Object readResolve() {
            return new MutableChampMap(this.deserializedEntries);
        }
    }
}

