/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.util.Iterator;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.jhotdraw8.icollection.ChampVectorSet;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedSetFacade;
import org.jhotdraw8.icollection.impl.champ.AbstractMutableChampSet;
import org.jhotdraw8.icollection.impl.champ.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champ.ChangeEvent;
import org.jhotdraw8.icollection.impl.champ.Node;
import org.jhotdraw8.icollection.impl.champ.OrderedPair;
import org.jhotdraw8.icollection.impl.champ.ReverseTombSkippingVectorSpliterator;
import org.jhotdraw8.icollection.impl.champ.SequencedData;
import org.jhotdraw8.icollection.impl.champ.SequencedElement;
import org.jhotdraw8.icollection.impl.champ.TombSkippingVectorSpliterator;
import org.jhotdraw8.icollection.impl.iteration.FailFastIterator;
import org.jhotdraw8.icollection.impl.iteration.FailFastSpliterator;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedSet;
import org.jhotdraw8.icollection.sequenced.ReversedSequencedSetView;
import org.jhotdraw8.icollection.serialization.SetSerializationProxy;
import org.jspecify.annotations.Nullable;

public class MutableChampVectorSet<E>
extends AbstractMutableChampSet<E, SequencedElement<E>>
implements ReadOnlySequencedSet<E>,
SequencedSet<E> {
    private static final long serialVersionUID = 0L;
    private int offset = 0;
    private VectorList<Object> vector;

    public MutableChampVectorSet() {
        this.root = BitmapIndexedNode.emptyNode();
        this.vector = VectorList.of();
    }

    public MutableChampVectorSet(Iterable<? extends E> c) {
        if (c instanceof MutableChampVectorSet) {
            c = ((MutableChampVectorSet)c).toImmutable();
        }
        if (c instanceof ChampVectorSet) {
            ChampVectorSet that = (ChampVectorSet)c;
            this.root = that.root;
            this.size = that.size;
            this.offset = that.offset;
            this.vector = that.vector;
        } else {
            this.root = BitmapIndexedNode.emptyNode();
            this.vector = VectorList.of();
            this.addAll(c);
        }
    }

    @Override
    public boolean add(@Nullable E e) {
        return this.addLast(e, false);
    }

    @Override
    public void addFirst(@Nullable E e) {
        this.addFirst(e, true);
    }

    private boolean addFirst(@Nullable E e, boolean moveToFirst) {
        ChangeEvent details = new ChangeEvent();
        SequencedElement<E> newElem = new SequencedElement<E>(e, -this.offset - 1);
        this.root = this.root.put(this.makeOwner(), newElem, SequencedElement.keyHash(e), 0, details, moveToFirst ? SequencedElement::putAndMoveToFirst : SequencedElement::put, Objects::equals, SequencedElement::elementKeyHash);
        boolean modified = details.isModified();
        if (modified) {
            if (details.isReplaced()) {
                if (moveToFirst) {
                    OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(this.vector, (SequencedElement)details.getOldDataNonNull(), this.offset);
                    this.vector = result.first();
                }
            } else {
                ++this.size;
            }
            ++this.offset;
            ++this.modCount;
            this.vector = this.vector.addFirst((Object)newElem);
            this.renumber();
        }
        return modified;
    }

    @Override
    public void addLast(@Nullable E e) {
        this.addLast(e, true);
    }

    private boolean addLast(@Nullable E e, boolean moveToLast) {
        ChangeEvent details = new ChangeEvent();
        SequencedElement<E> newElem = new SequencedElement<E>(e, this.offset + this.vector.size());
        this.root = this.root.put(this.makeOwner(), newElem, SequencedElement.keyHash(e), 0, details, moveToLast ? SequencedElement::putAndMoveToLast : SequencedElement::put, Objects::equals, SequencedElement::elementKeyHash);
        boolean modified = details.isModified();
        if (modified) {
            SequencedElement oldElem = (SequencedElement)details.getOldData();
            if (details.isReplaced()) {
                OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(this.vector, oldElem, this.offset);
                this.vector = result.first();
                this.offset = result.second();
            } else {
                ++this.modCount;
                ++this.size;
            }
            this.vector = this.vector.add((Object)newElem);
            this.renumber();
        }
        return modified;
    }

    @Override
    public void clear() {
        this.root = BitmapIndexedNode.emptyNode();
        this.vector = VectorList.of();
        this.size = 0;
        ++this.modCount;
        this.offset = -1;
    }

    @Override
    public MutableChampVectorSet<E> clone() {
        return (MutableChampVectorSet)super.clone();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return Node.NO_DATA != this.root.find(new SequencedElement<Object>(o), SequencedElement.keyHash(o), 0, Objects::equals);
    }

    @Override
    public E getFirst() {
        return ((SequencedElement)this.vector.getFirst()).getElement();
    }

    @Override
    public E getLast() {
        return ((SequencedElement)this.vector.getLast()).getElement();
    }

    @Override
    public Iterator<E> iterator() {
        return new FailFastIterator<Object>(Spliterators.iterator(new TombSkippingVectorSpliterator<Object>(this.vector.trie, o -> ((SequencedElement)o).getElement(), 0, this.size, this.vector.size(), 81)), this::iteratorRemove, () -> this.modCount);
    }

    private Iterator<E> reverseIterator() {
        return new FailFastIterator<Object>(Spliterators.iterator(new ReverseTombSkippingVectorSpliterator<Object>(this.vector, o -> ((SequencedElement)o).getElement(), this.size(), 81)), this::iteratorRemove, () -> this.modCount);
    }

    private Spliterator<E> reverseSpliterator() {
        return new FailFastSpliterator<Object>(new ReverseTombSkippingVectorSpliterator<Object>(this.vector, o -> ((SequencedElement)o).getElement(), this.size(), 81), () -> this.modCount, null);
    }

    @Override
    public Spliterator<E> spliterator() {
        return new FailFastSpliterator<Object>(new TombSkippingVectorSpliterator<Object>(this.vector.trie, o -> ((SequencedElement)o).getElement(), 0, this.size(), this.vector.size(), 81), () -> this.modCount, null);
    }

    private void iteratorRemove(E element) {
        this.owner = null;
        this.remove(element);
    }

    @Override
    public ReadOnlySequencedSet<E> readOnlyReversed() {
        return new ReadOnlySequencedSetFacade(this.reversed());
    }

    @Override
    public boolean remove(Object o) {
        ChangeEvent details = new ChangeEvent();
        this.root = this.root.remove(this.makeOwner(), new SequencedElement<Object>(o), SequencedElement.keyHash(o), 0, details, Objects::equals);
        boolean modified = details.isModified();
        if (modified) {
            OrderedPair<VectorList<Object>, Integer> result = SequencedData.vecRemove(this.vector, (SequencedElement)details.getOldDataNonNull(), this.offset);
            --this.size;
            ++this.modCount;
            this.vector = result.first();
            this.offset = result.second();
            this.renumber();
        }
        return modified;
    }

    @Override
    public E removeFirst() {
        E e = this.getFirst();
        this.remove(e);
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.getLast();
        this.remove(e);
        return e;
    }

    private void renumber() {
        if (SequencedData.vecMustRenumber(this.size, this.offset, this.vector.size())) {
            OrderedPair<BitmapIndexedNode<SequencedElement>, VectorList<Object>> result = SequencedData.vecRenumber(this.makeOwner(), this.size, this.vector.size(), this.root, this.vector.trie, SequencedElement::elementKeyHash, Objects::equals, (e, seq) -> new SequencedElement(e.getElement(), (int)seq));
            this.root = result.first();
            this.vector = result.second();
            this.offset = 0;
        }
    }

    @Override
    public SequencedSet<E> reversed() {
        return new ReversedSequencedSetView(this, this::reverseIterator, this::reverseSpliterator);
    }

    public ChampVectorSet<E> toImmutable() {
        this.owner = null;
        return this.size == 0 ? ChampVectorSet.of() : new ChampVectorSet(this.root, this.vector, this.size, this.offset);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy<E>
    extends SetSerializationProxy<E> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(Set<E> target) {
            super(target);
        }

        @Override
        protected Object readResolve() {
            return new MutableChampVectorSet(this.deserializedElements);
        }
    }
}

