/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.jhotdraw8.icollection.NaturalComparator;
import org.jhotdraw8.icollection.RedBlackSet;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedSetFacade;
import org.jhotdraw8.icollection.impl.iteration.FailFastIterator;
import org.jhotdraw8.icollection.impl.iteration.FailFastSpliterator;
import org.jhotdraw8.icollection.impl.iteration.MappedIterator;
import org.jhotdraw8.icollection.impl.redblack.Node;
import org.jhotdraw8.icollection.impl.redblack.RedBlackTree;
import org.jhotdraw8.icollection.navigable.DescendingNavigableSetView;
import org.jhotdraw8.icollection.navigable.SubsetNavigableSetView;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlyNavigableSet;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedSet;
import org.jhotdraw8.icollection.serialization.SortedSetSerializationProxy;
import org.jspecify.annotations.Nullable;

public class MutableRedBlackSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Serializable,
Cloneable,
ReadOnlyNavigableSet<E> {
    private static final long serialVersionUID = 0L;
    final Comparator<E> comparator;
    protected transient int modCount;
    transient RedBlackTree<E, Void> root;

    public MutableRedBlackSet(@Nullable Comparator<E> comparator) {
        this.comparator = comparator == null ? NaturalComparator.instance() : comparator;
        this.root = RedBlackTree.empty();
    }

    public MutableRedBlackSet(@Nullable Comparator<E> comparator, Collection<? extends E> c) {
        this.comparator = comparator == null ? NaturalComparator.instance() : comparator;
        this.root = RedBlackTree.empty();
        ((AbstractCollection)this).addAll(c);
    }

    public MutableRedBlackSet() {
        this.comparator = NaturalComparator.instance();
        this.root = RedBlackTree.empty();
    }

    public MutableRedBlackSet(Iterable<? extends E> c) {
        this.comparator = NaturalComparator.instance();
        this.root = RedBlackTree.empty();
        this.addAll(c);
    }

    MutableRedBlackSet(@Nullable Comparator<E> comparator, RedBlackTree<E, Void> root) {
        this.comparator = comparator == null ? NaturalComparator.instance() : comparator;
        this.root = root;
    }

    @Override
    public boolean add(E e) {
        RedBlackTree<E, Object> newRoot = this.root.insert(e, null, this.comparator);
        if (newRoot.size() != this.root.size()) {
            this.root = newRoot;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Iterable<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public @Nullable E ceiling(E e) {
        return this.root.ceiling(e, this.comparator).keyOrNull();
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            ++this.modCount;
            this.root = RedBlackTree.empty();
        }
    }

    public MutableRedBlackSet<E> clone() {
        try {
            return (MutableRedBlackSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    @Override
    public @Nullable Comparator<? super E> comparator() {
        return this.comparator == NaturalComparator.instance() ? null : this.comparator;
    }

    @Override
    public boolean contains(Object o) {
        return this.root.contains(o, this.comparator);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new FailFastIterator<Object>(new MappedIterator<Object, Node>(this.root.reverseIterator(), Map.Entry::getKey), this::iteratorRemove, this::getModCount);
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new DescendingNavigableSetView(this, this::getModCount);
    }

    @Override
    public E first() {
        return this.root.min().getKey();
    }

    @Override
    public @Nullable E floor(E e) {
        return this.root.floor(e, this.comparator).keyOrNull();
    }

    @Override
    public E getFirst() {
        return this.first();
    }

    @Override
    public E getLast() {
        return this.last();
    }

    protected int getModCount() {
        return this.modCount;
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new SubsetNavigableSetView<Object>(this, this::getModCount, true, null, true, false, toElement, inclusive, true);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public @Nullable E higher(E e) {
        return this.root.higher(e, this.comparator).keyOrNull();
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new FailFastIterator<Object>(new MappedIterator<Object, Node>(this.root.iterator(), Map.Entry::getKey), this::iteratorRemove, this::getModCount);
    }

    private void iteratorRemove(E e) {
        this.remove(e);
    }

    @Override
    public E last() {
        return this.root.max().getKey();
    }

    @Override
    public @Nullable E lower(E e) {
        return this.root.lower(e, this.comparator).keyOrNull();
    }

    @Override
    public @Nullable E pollFirst() {
        E value = this.root.min().keyOrNull();
        this.root = this.root.delete(value, this.comparator);
        return value;
    }

    @Override
    public @Nullable E pollLast() {
        E value = this.root.max().keyOrNull();
        this.root = this.root.delete(value, this.comparator);
        return value;
    }

    @Override
    public ReadOnlySequencedSet<E> readOnlyReversed() {
        return new ReadOnlySequencedSetFacade<Object>(this::reverseIterator, this::iterator, this::size, this::contains, this::getLast, this::getFirst, 1024);
    }

    @Override
    public boolean remove(Object o) {
        RedBlackTree<Object, Void> newRoot = this.root.delete(o, this.comparator);
        if (newRoot.size() != this.root.size()) {
            this.root = newRoot;
            ++this.modCount;
            return true;
        }
        return false;
    }

    Iterator<E> reverseIterator() {
        return new FailFastIterator<Object>(new MappedIterator<Object, Node>(this.root.reverseIterator(), Map.Entry::getKey), this::iteratorRemove, this::getModCount);
    }

    @Override
    public int size() {
        return this.root.size();
    }

    @Override
    public Spliterator<E> spliterator() {
        return new FailFastSpliterator(NavigableSet.super.spliterator(), this::getModCount, this.comparator == NaturalComparator.instance() ? null : this.comparator);
    }

    @Override
    public Stream<E> stream() {
        return super.stream();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new SubsetNavigableSetView<E>(this, this::getModCount, false, fromElement, fromInclusive, false, toElement, toInclusive, true);
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new SubsetNavigableSetView<Object>(this, this::getModCount, false, fromElement, inclusive, true, null, true, true);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    public RedBlackSet<E> toImmutable() {
        return new RedBlackSet<E>(this.comparator, this.root);
    }

    @Override
    public String toString() {
        return ReadOnlyCollection.iterableToString(this);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy<E>
    extends SortedSetSerializationProxy<E> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(SortedSet<E> target) {
            super(target);
        }

        @Override
        protected Object readResolve() {
            return new MutableRedBlackSet(this.deserializedComparator, this.deserializedElements);
        }
    }
}

