/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.jhotdraw8.icollection.MutableVectorList;
import org.jhotdraw8.icollection.PrivateData;
import org.jhotdraw8.icollection.facade.ReadOnlyListFacade;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.impl.vector.BitMappedTrie;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedCollection;
import org.jhotdraw8.icollection.serialization.ListSerializationProxy;
import org.jspecify.annotations.Nullable;

public class VectorList<E>
implements ImmutableList<E>,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final VectorList<?> EMPTY = new VectorList();
    final transient BitMappedTrie<E> trie;

    protected VectorList() {
        this.trie = BitMappedTrie.empty();
    }

    protected VectorList(@Nullable Iterable<? extends E> iterable) {
        ReadOnlyCollection rc;
        Collection c;
        if (iterable == null) {
            this.trie = BitMappedTrie.empty();
        } else if (iterable instanceof Collection && (c = (Collection)iterable).isEmpty() || iterable instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)iterable).isEmpty()) {
            this.trie = BitMappedTrie.empty();
        } else if (iterable instanceof VectorList) {
            VectorList that = (VectorList)iterable;
            this.trie = that.trie;
        } else if (iterable instanceof MutableVectorList) {
            MutableVectorList mc = (MutableVectorList)iterable;
            VectorList that = mc.toImmutable();
            this.trie = that.trie;
        } else if (iterable instanceof Collection) {
            Collection c2 = (Collection)iterable;
            this.trie = BitMappedTrie.ofAll(c2.toArray());
        } else {
            BitMappedTrie<E> root = BitMappedTrie.empty().appendAll(iterable);
            this.trie = root.length() == 0 ? BitMappedTrie.empty() : root;
        }
    }

    VectorList(BitMappedTrie<E> trie) {
        this.trie = trie;
    }

    protected VectorList(PrivateData privateData) {
        this.trie = (BitMappedTrie)privateData.get();
    }

    protected VectorList<E> newInstance(PrivateData privateData) {
        return new VectorList<E>(privateData);
    }

    private VectorList<E> newInstance(BitMappedTrie<E> trie) {
        return this.newInstance(new PrivateData(trie));
    }

    public static <T> VectorList<T> of() {
        return EMPTY;
    }

    @SafeVarargs
    public static <T> VectorList<T> of(T ... t) {
        return new VectorList(BitMappedTrie.ofAll(t));
    }

    public static <T> VectorList<T> ofIterator(Iterator<T> iterator) {
        return VectorList.of().addAll(() -> iterator);
    }

    public static <T> VectorList<T> ofStream(Stream<T> stream) {
        return VectorList.of().addAll(stream::iterator);
    }

    public static <T> VectorList<T> copyOf(Iterable<? extends T> iterable) {
        ReadOnlyCollection rc;
        Collection c;
        Objects.requireNonNull(iterable, "iterable is null");
        if (iterable instanceof Collection && (c = (Collection)iterable).isEmpty() || iterable instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)iterable).isEmpty()) {
            return VectorList.of();
        }
        if (iterable instanceof VectorList) {
            return (VectorList)iterable;
        }
        if (iterable instanceof MutableVectorList) {
            MutableVectorList mc = (MutableVectorList)iterable;
            return mc.toImmutable();
        }
        if (iterable instanceof Collection) {
            c = (Collection)iterable;
            return new VectorList(BitMappedTrie.ofAll(c.toArray()));
        }
        BitMappedTrie<T> root = BitMappedTrie.empty().appendAll(iterable);
        return root.length() == 0 ? VectorList.of() : new VectorList<T>(root);
    }

    @Override
    public <T> VectorList<T> empty() {
        return VectorList.of();
    }

    @Override
    public VectorList<E> add(E element) {
        return this.newInstance(this.trie.append(element));
    }

    @Override
    public VectorList<E> add(int index, E element) {
        if (index == 0) {
            return this.newInstance(this.trie.prepend(element));
        }
        return index == this.size() ? this.add((Object)element) : this.addAll(index, Collections.singleton(element));
    }

    @Override
    public VectorList<E> addAll(Iterable<? extends E> c) {
        int cSize;
        Objects.requireNonNull(c, "iterable is null");
        if (this.isEmpty()) {
            return VectorList.copyOf(c);
        }
        if (c instanceof Collection) {
            Collection cc = (Collection)c;
            v0 = cc.size();
        } else if (c instanceof ReadOnlyCollection) {
            ReadOnlyCollection rcc = (ReadOnlyCollection)c;
            v0 = rcc.size();
        } else {
            v0 = cSize = -1;
        }
        if (cSize == 0) {
            return this;
        }
        if (cSize < 0) {
            BitMappedTrie<E> newRoot = this.trie;
            int newSize = this.size();
            for (E e : c) {
                newRoot = newRoot.append(e);
                ++newSize;
            }
            return this.newInstance(newRoot);
        }
        return this.newInstance(this.trie.appendAll(c));
    }

    @Override
    public VectorList<E> addFirst(@Nullable E element) {
        return this.add(0, (Object)element);
    }

    @Override
    public VectorList<E> addLast(@Nullable E element) {
        return this.newInstance(this.trie.append(element));
    }

    @Override
    public VectorList<E> addAll(int index, Iterable<? extends E> c) {
        Objects.requireNonNull(c, "c is null");
        if (index >= 0 && index <= this.size()) {
            ImmutableList begin = ((VectorList)this.readOnlySubList(0, index)).addAll((Iterable)c);
            ImmutableList end = this.readOnlySubList(index, this.size());
            return ((VectorList)begin).addAll((Iterable)end);
        }
        throw new IndexOutOfBoundsException("addAll(" + index + ", c) on Vector of size " + this.size());
    }

    @Override
    public ReadOnlySequencedCollection<E> readOnlyReversed() {
        return new ReadOnlyListFacade<Object>(this::size, index -> this.get(this.size() - 1 - index), () -> this);
    }

    @Override
    public VectorList<E> reverse() {
        return this.size() < 2 ? this : VectorList.copyOf(this.readOnlyReversed());
    }

    @Override
    public VectorList<E> remove(E element) {
        int index = this.indexOf(element);
        return index < 0 ? this : this.removeAt(index);
    }

    @Override
    public VectorList<E> removeAt(int index) {
        return this.removeRange(index, index + 1);
    }

    @Override
    public VectorList<E> removeFirst() {
        return (VectorList)ImmutableList.super.removeFirst();
    }

    @Override
    public VectorList<E> removeLast() {
        return (VectorList)ImmutableList.super.removeLast();
    }

    @Override
    public VectorList<E> retainAll(Iterable<?> c) {
        Collection set;
        if (this.isEmpty()) {
            return this;
        }
        if (c instanceof Collection) {
            HashSet cc = (HashSet)c;
            set = cc;
        } else if (c instanceof ReadOnlyCollection) {
            ReadOnlyCollection rc = (ReadOnlyCollection)c;
            set = rc.asCollection();
        } else {
            set = new HashSet();
            c.forEach(e -> set.add(e));
        }
        if (set.isEmpty()) {
            return VectorList.of();
        }
        List t = this.toMutable();
        boolean modified = false;
        for (E key : this) {
            if (set.contains(key)) continue;
            ((AbstractCollection)((Object)t)).remove(key);
            modified = true;
        }
        return modified ? ((MutableVectorList)t).toImmutable() : this;
    }

    @Override
    public VectorList<E> removeRange(int fromIndex, int toIndex) {
        Objects.checkIndex(fromIndex, toIndex + 1);
        Objects.checkIndex(toIndex, this.size() + 1);
        BitMappedTrie<E> begin = this.trie.take(fromIndex);
        BitMappedTrie<E> end = this.trie.drop(toIndex);
        return this.newInstance(begin.append(end.iterator(), end.length));
    }

    @Override
    public VectorList<E> removeAll(Iterable<?> c) {
        if (this.isEmpty()) {
            return this;
        }
        ImmutableList<E> result = this;
        block0: for (Object e : c) {
            int index = result.indexOf(e);
            while (index >= 0) {
                if ((result = ((VectorList)result).removeAt(index)).isEmpty()) break block0;
                index = ((VectorList)result).indexOf(e, index);
            }
        }
        return result;
    }

    @Override
    public VectorList<E> set(int index, E element) {
        BitMappedTrie<E> newRoot = this.trie.update(index, element);
        return newRoot == this.trie ? this : this.newInstance(newRoot);
    }

    @Override
    public E get(int index) {
        Objects.checkIndex(index, this.size());
        return this.trie.get(index);
    }

    @Override
    public VectorList<E> readOnlySubList(int fromIndex, int toIndex) {
        Objects.checkIndex(fromIndex, toIndex + 1);
        Objects.checkIndex(toIndex, this.size() + 1);
        BitMappedTrie<E> newRoot = this.trie;
        if (toIndex < this.size()) {
            newRoot = newRoot.take(toIndex);
        }
        if (fromIndex > 0) {
            newRoot = newRoot.drop(fromIndex);
        }
        return newRoot == this.trie ? this : this.newInstance(newRoot);
    }

    @Override
    public int size() {
        return this.trie.length;
    }

    public int indexOf(Object o, int fromIndex) {
        if (fromIndex < this.size()) {
            Iterator<E> i = this.trie.iterator(fromIndex, this.size());
            while (i.hasNext()) {
                E e = i.next();
                if (Objects.equals(o, e)) {
                    return fromIndex;
                }
                ++fromIndex;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        for (E e : this) {
            if (!Objects.equals(e, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ReadOnlyList.iteratorToHashCode(this.iterator());
    }

    @Override
    public MutableVectorList<E> toMutable() {
        return new MutableVectorList(this);
    }

    private Object writeReplace() {
        return new SerializationProxy(this.toMutable());
    }

    @Override
    public Iterator<E> iterator() {
        return this.trie.iterator(0, this.size());
    }

    @Override
    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.trie.spliterator(0, this.size(), 16464);
    }

    @Override
    public boolean equals(Object obj) {
        return ReadOnlyList.listEquals(this, obj);
    }

    public String toString() {
        return ReadOnlyCollection.iterableToString(this);
    }

    private static class SerializationProxy<E>
    extends ListSerializationProxy<E> {
        private static final long serialVersionUID = 0L;

        protected SerializationProxy(List<E> target) {
            super(target);
        }

        @Override
        protected Object readResolve() {
            return VectorList.of().addAll((Iterable)this.deserializedElements);
        }
    }
}

