/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jhotdraw8.icollection.impl.iteration.IteratorSpliterator;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jspecify.annotations.Nullable;

public class CollectionFacade<E>
extends AbstractCollection<E>
implements ReadOnlyCollection<E> {
    protected final Supplier<Iterator<E>> iteratorFunction;
    protected final Supplier<Spliterator<E>> spliteratorFunction;
    protected final IntSupplier sizeFunction;
    protected final Predicate<Object> containsFunction;
    protected final Runnable clearFunction;
    protected final Predicate<Object> removeFunction;
    protected final Predicate<E> addFunction;

    public CollectionFacade(ReadOnlyCollection<E> backingCollection) {
        this(backingCollection::iterator, backingCollection::spliterator, backingCollection::size, backingCollection::contains, null, null, null);
    }

    public CollectionFacade(Collection<E> backingCollection) {
        this(backingCollection::iterator, backingCollection::spliterator, backingCollection::size, backingCollection::contains, backingCollection::clear, backingCollection::add, backingCollection::remove);
    }

    public CollectionFacade(Supplier<Iterator<E>> iteratorFunction, IntSupplier sizeFunction, Predicate<Object> containsFunction) {
        this(iteratorFunction, null, sizeFunction, containsFunction, null, null, null);
    }

    public CollectionFacade(Supplier<Iterator<E>> iteratorFunction, @Nullable Supplier<Spliterator<E>> spliteratorFunction, IntSupplier sizeFunction, Predicate<Object> containsFunction, @Nullable Runnable clearFunction, @Nullable Predicate<E> addFunction, @Nullable Predicate<Object> removeFunction) {
        this.iteratorFunction = iteratorFunction;
        this.spliteratorFunction = spliteratorFunction == null ? () -> new IteratorSpliterator((Iterator)iteratorFunction.get(), sizeFunction.getAsInt(), 64, null) : spliteratorFunction;
        this.sizeFunction = sizeFunction;
        this.containsFunction = containsFunction;
        this.addFunction = addFunction == null ? o -> {
            throw new UnsupportedOperationException();
        } : addFunction;
        this.clearFunction = clearFunction == null ? () -> {
            throw new UnsupportedOperationException();
        } : clearFunction;
        this.removeFunction = removeFunction == null ? o -> {
            throw new UnsupportedOperationException();
        } : removeFunction;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFunction.test(o);
    }

    @Override
    public boolean add(E e) {
        return this.addFunction.test(e);
    }

    @Override
    public void clear() {
        this.clearFunction.run();
    }

    @Override
    public Stream<E> stream() {
        return super.stream();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.spliteratorFunction.get();
    }

    @Override
    public Iterator<E> iterator() {
        return this.iteratorFunction.get();
    }

    @Override
    public int size() {
        return this.sizeFunction.getAsInt();
    }

    @Override
    public boolean contains(Object o) {
        return this.containsFunction.test(o);
    }
}

