/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jhotdraw8.icollection.impl.iteration.Iterators;
import org.jhotdraw8.icollection.readonly.AbstractReadOnlyMap;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jspecify.annotations.Nullable;

public class ImmutableMapFacade<K, V>
extends AbstractReadOnlyMap<K, V>
implements ImmutableMap<K, V> {
    private final Map<K, V> target;
    private final Function<Map<K, V>, Map<K, V>> cloneFunction;

    public ImmutableMapFacade(Map<K, V> target, Function<Map<K, V>, Map<K, V>> cloneFunction) {
        this.target = target;
        this.cloneFunction = cloneFunction;
    }

    @Override
    public ImmutableMapFacade<K, V> clear() {
        if (this.isEmpty()) {
            return this;
        }
        Map<K, V> clone = this.cloneFunction.apply(this.target);
        clone.clear();
        return new ImmutableMapFacade<K, V>(clone, this.cloneFunction);
    }

    @Override
    public ImmutableMapFacade<K, V> put(K key, @Nullable V value) {
        if (this.containsKey(key) && Objects.equals(this.get(key), value)) {
            return this;
        }
        Map<K, V> clone = this.cloneFunction.apply(this.target);
        clone.put(key, value);
        return new ImmutableMapFacade<K, V>(clone, this.cloneFunction);
    }

    @Override
    public ImmutableMapFacade<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        Map<K, V> clone = this.cloneFunction.apply(this.target);
        for (Map.Entry<K, V> e : c) {
            clone.put(e.getKey(), e.getValue());
        }
        if (clone.equals(this.target)) {
            return this;
        }
        return new ImmutableMapFacade<K, V>(clone, this.cloneFunction);
    }

    @Override
    public ImmutableMapFacade<K, V> remove(K key) {
        if (!this.containsKey(key)) {
            return this;
        }
        Map<K, V> clone = this.cloneFunction.apply(this.target);
        clone.remove(key);
        return new ImmutableMapFacade<K, V>(clone, this.cloneFunction);
    }

    @Override
    public ImmutableMapFacade<K, V> removeAll(Iterable<? extends K> c) {
        if (this.isEmpty()) {
            return this;
        }
        Map<K, V> clone = this.cloneFunction.apply(this.target);
        if (c instanceof Collection) {
            Collection coll = (Collection)c;
            if (coll.isEmpty()) {
                return this;
            }
            clone.keySet().removeAll(coll);
        } else {
            boolean changed = false;
            for (K k : c) {
                changed |= clone.containsKey(k);
                clone.remove(k);
            }
            if (!changed) {
                return this;
            }
        }
        return new ImmutableMapFacade<K, V>(clone, this.cloneFunction);
    }

    @Override
    public ImmutableMapFacade<K, V> retainAll(Iterable<? extends K> c) {
        Collection collection;
        if (this.isEmpty()) {
            return this;
        }
        Map<K, V> clone = this.cloneFunction.apply(this.target);
        if (c instanceof ReadOnlyCollection) {
            ReadOnlyCollection rc = (ReadOnlyCollection)c;
            collection = rc.asCollection();
        } else if (c instanceof Collection) {
            Collection cc;
            collection = cc = (Collection)c;
        } else {
            collection = new HashSet();
            c.forEach(collection::add);
        }
        return clone.keySet().retainAll(collection) ? new ImmutableMapFacade<K, V>(clone, this.cloneFunction) : this;
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return Iterators.unmodifiableIterator(this.target.entrySet().iterator());
    }

    @Override
    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public @Nullable V get(Object key) {
        return this.target.get(key);
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.target.containsKey(key);
    }

    @Override
    public Map<K, V> toMutable() {
        return this.cloneFunction.apply(this.target);
    }

    @Override
    public int characteristics() {
        return 0x400 | super.characteristics();
    }
}

