/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.icollection.impl.iteration.IteratorSpliterator;
import org.jhotdraw8.icollection.impl.iteration.Iterators;
import org.jhotdraw8.icollection.readonly.AbstractReadOnlySet;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;

public class ImmutableSetFacade<E>
extends AbstractReadOnlySet<E>
implements ImmutableSet<E> {
    private final Set<E> target;
    private final Function<Set<E>, Set<E>> cloneFunction;

    public ImmutableSetFacade(Set<E> target, Function<Set<E>, Set<E>> cloneFunction) {
        this.target = target;
        this.cloneFunction = cloneFunction;
    }

    @Override
    public <T> ImmutableSet<T> empty() {
        return new ImmutableSetFacade(new LinkedHashSet(), k -> (Set)((LinkedHashSet)k).clone());
    }

    @Override
    public ImmutableSet<E> add(E element) {
        Set<E> clone = this.cloneFunction.apply(this.target);
        return clone.add(element) ? new ImmutableSetFacade<E>(clone, this.cloneFunction) : this;
    }

    @Override
    public ImmutableSet<E> addAll(Iterable<? extends E> c) {
        Set<E> clone = this.cloneFunction.apply(this.target);
        boolean changed = false;
        for (E e : c) {
            changed |= clone.add(e);
        }
        return changed ? new ImmutableSetFacade<E>(clone, this.cloneFunction) : this;
    }

    @Override
    public ImmutableSet<E> remove(E element) {
        Set<E> clone = this.cloneFunction.apply(this.target);
        return clone.remove(element) ? new ImmutableSetFacade<E>(clone, this.cloneFunction) : this;
    }

    @Override
    public ImmutableSet<E> removeAll(Iterable<?> c) {
        Set<E> clone = this.cloneFunction.apply(this.target);
        boolean changed = false;
        for (Object e : c) {
            changed |= clone.remove(e);
        }
        return changed ? new ImmutableSetFacade<E>(clone, this.cloneFunction) : this;
    }

    @Override
    public ImmutableSet<E> retainAll(Iterable<?> c) {
        Collection collection;
        if (this.isEmpty()) {
            return this;
        }
        Set<E> clone = this.cloneFunction.apply(this.target);
        if (c instanceof ReadOnlyCollection) {
            ReadOnlyCollection rc = (ReadOnlyCollection)c;
            collection = rc.asCollection();
        } else if (c instanceof Collection) {
            Collection cc;
            collection = cc = (Collection)c;
        } else {
            collection = new HashSet();
            c.forEach(e -> collection.add(e));
        }
        return clone.retainAll(collection) ? new ImmutableSetFacade<E>(clone, this.cloneFunction) : this;
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.target.contains(o);
    }

    @Override
    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.unmodifiableIterator(this.target.iterator());
    }

    @Override
    public Spliterator<E> spliterator() {
        return new IteratorSpliterator<E>(this.iterator(), this.size(), this.characteristics(), null);
    }

    @Override
    public Set<E> toMutable() {
        return this.cloneFunction.apply(this.target);
    }

    @Override
    public int characteristics() {
        return 0x400 | super.characteristics();
    }
}

