/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.jhotdraw8.icollection.facade.ReadOnlyListFacade;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.impl.iteration.FailFastIterator;
import org.jhotdraw8.icollection.impl.iteration.FailFastSpliterator;
import org.jhotdraw8.icollection.impl.iteration.MutableListIterator;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedCollection;
import org.jhotdraw8.icollection.sequenced.ReversedListView;
import org.jspecify.annotations.Nullable;

public class MutableListFacade<E>
extends AbstractList<E>
implements ReadOnlyList<E>,
List<E> {
    private ImmutableList<E> backingList;
    private int modCount;

    public MutableListFacade(ImmutableList<E> backingList) {
        this.backingList = backingList;
    }

    @Override
    public void addFirst(E e) {
        this.backingList = this.backingList.add(0, e);
        ++this.modCount;
    }

    @Override
    public void addLast(E e) {
        this.backingList = this.backingList.add((Object)e);
        ++this.modCount;
    }

    @Override
    public List<E> reversed() {
        return new ReversedListView(this, this::getModCount);
    }

    private int getModCount() {
        return this.modCount;
    }

    @Override
    public ReadOnlySequencedCollection<E> readOnlyReversed() {
        return new ReadOnlyListFacade<Object>(() -> this.backingList.size(), index -> this.get(this.backingList.size() - 1 - index), () -> this);
    }

    @Override
    public boolean remove(Object o) {
        ImmutableList<E> oldList = this.backingList;
        this.backingList = this.backingList.remove(o);
        ++this.modCount;
        return oldList != this.backingList;
    }

    @Override
    public E remove(int index) {
        Object removed = this.backingList.get(index);
        this.backingList = this.backingList.removeAt(index);
        ++this.modCount;
        return removed;
    }

    @Override
    public void clear() {
        ImmutableList<E> oldList = this.backingList;
        this.backingList = this.backingList.empty();
        if (oldList != this.backingList) {
            ++this.modCount;
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new FailFastSpliterator(this.backingList.spliterator(), () -> this.modCount, null);
    }

    @Override
    public ReadOnlyList<E> readOnlySubList(int fromIndex, int toIndex) {
        int length = this.size();
        Objects.checkFromToIndex(fromIndex, toIndex, length);
        return new ReadOnlyListFacade<Object>(() -> toIndex - fromIndex, i -> this.get(i - fromIndex));
    }

    @Override
    public Stream<E> stream() {
        return this.backingList.stream();
    }

    @Override
    public Iterator<E> iterator() {
        MyIterator it = new MyIterator(this.backingList.iterator());
        return new FailFastIterator(it, () -> this.modCount);
    }

    public Iterator<E> reverseIterator() {
        MyIterator it = new MyIterator(this.backingList.readOnlyReversed().iterator());
        return new FailFastIterator(it, () -> this.modCount);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingList.contains(o);
    }

    @Override
    public boolean add(E e) {
        ImmutableList<E> oldList = this.backingList;
        this.backingList = this.backingList.add((Object)e);
        if (oldList != this.backingList) {
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E e) {
        this.backingList = this.backingList.add(index, e);
        ++this.modCount;
    }

    @Override
    public E set(int index, E e) {
        Object oldValue = this.backingList.get(index);
        this.backingList = this.backingList.set(index, e);
        return oldValue;
    }

    @Override
    public E get(int index) {
        return this.backingList.get(index);
    }

    @Override
    public E getFirst() {
        return ReadOnlyList.super.getFirst();
    }

    @Override
    public E getLast() {
        return ReadOnlyList.super.getLast();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new MutableListIterator(this, index, this::getModCount);
    }

    class MyIterator<EE>
    implements Iterator<EE> {
        final Iterator<EE> b;
        @Nullable EE current;
        boolean canRemove;

        MyIterator(Iterator<EE> b) {
            this.b = b;
        }

        @Override
        public boolean hasNext() {
            return this.b.hasNext();
        }

        @Override
        public EE next() {
            this.current = this.b.next();
            this.canRemove = true;
            return this.current;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            MutableListFacade.this.remove(this.current);
            this.canRemove = false;
        }
    }
}

