/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.stream.Stream;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.icollection.impl.iteration.FailFastIterator;
import org.jhotdraw8.icollection.impl.iteration.FailFastSpliterator;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public class MutableSetFacade<E>
extends AbstractSet<E>
implements ReadOnlySet<E> {
    private ImmutableSet<E> backingSet;
    private int modCount;

    public MutableSetFacade(ImmutableSet<E> backingSet) {
        this.backingSet = backingSet;
    }

    @Override
    public boolean remove(Object o) {
        ImmutableSet<E> oldSet = this.backingSet;
        this.backingSet = this.backingSet.remove(o);
        if (oldSet != this.backingSet) {
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ImmutableSet<E> oldSet = this.backingSet;
        this.backingSet = this.backingSet.empty();
        if (oldSet != this.backingSet) {
            ++this.modCount;
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new FailFastSpliterator(this.backingSet.spliterator(), () -> this.modCount, null);
    }

    @Override
    public Stream<E> stream() {
        return this.backingSet.stream();
    }

    @Override
    public Iterator<E> iterator() {
        Iterator it = new Iterator<E>(){
            final Iterator<E> b;
            E current;
            boolean canRemove;
            {
                this.b = MutableSetFacade.this.backingSet.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.b.hasNext();
            }

            @Override
            public E next() {
                this.current = this.b.next();
                this.canRemove = true;
                return this.current;
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException();
                }
                MutableSetFacade.this.remove(this.current);
                this.canRemove = false;
            }
        };
        return new FailFastIterator(it, () -> this.modCount);
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingSet.contains(o);
    }

    @Override
    public boolean add(E e) {
        ImmutableSet<E> oldSet = this.backingSet;
        this.backingSet = this.backingSet.add((Object)e);
        if (oldSet != this.backingSet) {
            ++this.modCount;
            return true;
        }
        return false;
    }
}

