/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.icollection.facade.ReadOnlySetFacade;
import org.jhotdraw8.icollection.impl.iteration.IteratorSpliterator;
import org.jhotdraw8.icollection.readonly.AbstractReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jspecify.annotations.Nullable;

public class ReadOnlyCollectionFacade<E>
extends AbstractReadOnlyCollection<E> {
    protected final Supplier<Iterator<E>> iteratorFunction;
    protected final IntSupplier sizeFunction;
    protected final Predicate<Object> containsFunction;
    protected final int characteristics;

    public ReadOnlyCollectionFacade(Supplier<Iterator<E>> iteratorFunction, @Nullable IntSupplier sizeFunction, Predicate<Object> containsFunction, int characteristics) {
        this.iteratorFunction = iteratorFunction;
        this.sizeFunction = sizeFunction;
        this.containsFunction = containsFunction;
        this.characteristics = characteristics;
    }

    public ReadOnlyCollectionFacade(Collection<E> c) {
        this(c::iterator, c::size, c::contains, 16448);
    }

    @Override
    public int size() {
        return this.sizeFunction.getAsInt();
    }

    @Override
    public boolean contains(Object o) {
        return this.containsFunction.test(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<? extends E> i;
            {
                this.i = ReadOnlyCollectionFacade.this.iteratorFunction.get();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Spliterator<E> spliterator() {
        return new IteratorSpliterator<E>(this.iterator(), this.size(), this.characteristics, null);
    }

    public boolean equals(Object o) {
        return ReadOnlySet.setEquals(new ReadOnlySetFacade(this), o);
    }

    public int hashCode() {
        return ReadOnlySet.iteratorToHashCode(this.iteratorFunction.get());
    }
}

