/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.jhotdraw8.icollection.readonly.AbstractReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedCollection;

public class ReadOnlyListFacade<E>
extends AbstractReadOnlyList<E> {
    private final IntSupplier sizeFunction;
    private final IntFunction<E> getFunction;
    private final Supplier<ReadOnlySequencedCollection<E>> readOnlyReversedFunction;

    public ReadOnlyListFacade(List<E> backingList) {
        this.sizeFunction = backingList::size;
        this.getFunction = backingList::get;
        this.readOnlyReversedFunction = () -> new ReadOnlyListFacade<Object>(this.sizeFunction, index -> this.getFunction.apply(this.sizeFunction.getAsInt() - index), () -> this);
    }

    public ReadOnlyListFacade(IntSupplier sizeFunction, IntFunction<E> getFunction) {
        this.sizeFunction = sizeFunction;
        this.getFunction = getFunction;
        this.readOnlyReversedFunction = () -> new ReadOnlyListFacade<Object>(sizeFunction, index -> getFunction.apply(sizeFunction.getAsInt() - index), () -> this);
    }

    public ReadOnlyListFacade(IntSupplier sizeFunction, IntFunction<E> getFunction, Supplier<ReadOnlySequencedCollection<E>> readOnlyReversedFunction) {
        this.sizeFunction = sizeFunction;
        this.getFunction = getFunction;
        this.readOnlyReversedFunction = readOnlyReversedFunction;
    }

    @Override
    public E get(int index) {
        return this.getFunction.apply(index);
    }

    @Override
    public ReadOnlySequencedCollection<E> readOnlyReversed() {
        return this.readOnlyReversedFunction.get();
    }

    @Override
    public ReadOnlyList<E> readOnlySubList(int fromIndex, int toIndex) {
        int length = this.size();
        Objects.checkFromToIndex(fromIndex, toIndex, length);
        return new ReadOnlyListFacade<Object>(() -> toIndex - fromIndex, i -> this.getFunction.apply(i - fromIndex), this.readOnlyReversedFunction);
    }

    @Override
    public int size() {
        return this.sizeFunction.getAsInt();
    }
}

