/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;
import org.jspecify.annotations.Nullable;

public class ReadOnlyMapFacade<K, V>
implements ReadOnlyMap<K, V> {
    protected final Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction;
    protected final IntSupplier sizeFunction;
    protected final Predicate<Object> containsKeyFunction;
    protected final Function<K, V> getFunction;

    public ReadOnlyMapFacade(ReadOnlyMap<K, V> m) {
        this(m::iterator, m::size, m::containsKey, m::get);
    }

    public ReadOnlyMapFacade(Map<K, V> m) {
        this(() -> m.entrySet().iterator(), m::size, m::containsKey, m::get);
    }

    public ReadOnlyMapFacade(Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction, IntSupplier sizeFunction, Predicate<Object> containsKeyFunction, Function<K, V> getFunction) {
        this.iteratorFunction = iteratorFunction;
        this.sizeFunction = sizeFunction;
        this.containsKeyFunction = containsKeyFunction;
        this.getFunction = getFunction;
    }

    @Override
    public @Nullable V get(Object key) {
        Object unchecked = key;
        return this.getFunction.apply(unchecked);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKeyFunction.test(key);
    }

    @Override
    public boolean isEmpty() {
        return this.sizeFunction.getAsInt() == 0;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.iteratorFunction.get();
    }

    @Override
    public int size() {
        return this.sizeFunction.getAsInt();
    }

    @Override
    public boolean containsEntry(@Nullable Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            return this.containsKey(key) && Objects.equals(entry.getValue(), this.get(key));
        }
        return false;
    }
}

