/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.icollection.facade.ReadOnlyMapFacade;
import org.jhotdraw8.icollection.readonly.ReadOnlyNavigableMap;
import org.jspecify.annotations.Nullable;

public class ReadOnlyNavigableMapFacade<K, V>
extends ReadOnlyMapFacade<K, V>
implements ReadOnlyNavigableMap<K, V> {
    private final Supplier<Map.Entry<K, V>> firstEntryFunction;
    private final Supplier<Map.Entry<K, V>> lastEntryFunction;
    private final Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction;
    private final int characteristics;
    final Function<K, Map.Entry<K, V>> ceilingFunction;
    final Function<K, Map.Entry<K, V>> floorFunction;
    final Function<K, Map.Entry<K, V>> higherFunction;
    final Function<K, Map.Entry<K, V>> lowerFunction;
    private final Supplier<Comparator<? super K>> comparatorSupplier;

    public ReadOnlyNavigableMapFacade(NavigableMap<K, V> target) {
        super(target);
        this.firstEntryFunction = target::firstEntry;
        this.lastEntryFunction = target::lastEntry;
        this.reverseIteratorFunction = () -> target.reversed().sequencedEntrySet().iterator();
        this.characteristics = 81;
        this.comparatorSupplier = target::comparator;
        this.ceilingFunction = target::ceilingEntry;
        this.floorFunction = target::floorEntry;
        this.higherFunction = target::higherEntry;
        this.lowerFunction = target::lowerEntry;
    }

    public ReadOnlyNavigableMapFacade(Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction, Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction, IntSupplier sizeFunction, Predicate<Object> containsKeyFunction, Function<K, V> getFunction, Supplier<Map.Entry<K, V>> firstEntryFunction, Supplier<Map.Entry<K, V>> lastEntryFunction, Function<K, Map.Entry<K, V>> ceilingFunction, Function<K, Map.Entry<K, V>> floorFunction, Function<K, Map.Entry<K, V>> higherFunction, Function<K, Map.Entry<K, V>> lowerFunction, int characteristics, @Nullable Supplier<Comparator<? super K>> comparator) {
        super(iteratorFunction, sizeFunction, containsKeyFunction, getFunction);
        this.firstEntryFunction = firstEntryFunction;
        this.lastEntryFunction = lastEntryFunction;
        this.reverseIteratorFunction = reverseIteratorFunction;
        this.characteristics = characteristics;
        this.comparatorSupplier = comparator;
        this.ceilingFunction = ceilingFunction;
        this.floorFunction = floorFunction;
        this.higherFunction = higherFunction;
        this.lowerFunction = lowerFunction;
    }

    @Override
    public  @Nullable Map.Entry<K, V> ceilingEntry(K k) {
        return this.ceilingFunction.apply(k);
    }

    @Override
    public  @Nullable Map.Entry<K, V> floorEntry(K k) {
        return this.floorFunction.apply(k);
    }

    @Override
    public  @Nullable Map.Entry<K, V> higherEntry(K k) {
        return this.higherFunction.apply(k);
    }

    @Override
    public  @Nullable Map.Entry<K, V> lowerEntry(K k) {
        return this.lowerFunction.apply(k);
    }

    @Override
    public ReadOnlyNavigableMap<K, V> readOnlyReversed() {
        return new ReadOnlyNavigableMapFacade<K, V>(this.reverseIteratorFunction, this.iteratorFunction, this.sizeFunction, this.containsKeyFunction, this.getFunction, this.lastEntryFunction, this.firstEntryFunction, this.floorFunction, this.ceilingFunction, this.lowerFunction, this.higherFunction, this.characteristics, () -> this.comparatorSupplier.get().reversed());
    }

    @Override
    public  @Nullable Map.Entry<K, V> firstEntry() {
        return this.firstEntryFunction.get();
    }

    @Override
    public  @Nullable Map.Entry<K, V> lastEntry() {
        return this.lastEntryFunction.get();
    }

    @Override
    public @Nullable Comparator<? super K> comparator() {
        return this.comparatorSupplier.get();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

