/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.icollection.readonly.AbstractReadOnlySet;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public class ReadOnlySetFacade<E>
extends AbstractReadOnlySet<E> {
    protected final Supplier<Iterator<E>> iteratorFunction;
    protected final IntSupplier sizeFunction;
    protected final Predicate<Object> containsFunction;
    protected final int characteristics;

    public ReadOnlySetFacade(ReadOnlyCollection<E> backingSet) {
        this(backingSet::iterator, backingSet::size, backingSet::contains, 1089);
    }

    public ReadOnlySetFacade(Collection<E> backingSet) {
        this(backingSet::iterator, backingSet::size, backingSet::contains, 1089);
    }

    public ReadOnlySetFacade(Supplier<Iterator<E>> iteratorFunction, IntSupplier sizeFunction, Predicate<Object> containsFunction, int characteristics) {
        this.iteratorFunction = iteratorFunction;
        this.sizeFunction = sizeFunction;
        this.containsFunction = containsFunction;
        this.characteristics = characteristics | 0x40 | 0x400 | 1;
    }

    @Override
    public int size() {
        return this.sizeFunction.getAsInt();
    }

    @Override
    public boolean contains(Object o) {
        return this.containsFunction.test(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<? extends E> i;
            {
                this.i = ReadOnlySetFacade.this.iteratorFunction.get();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return this.i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), this.characteristics);
    }

    @Override
    public int hashCode() {
        return ReadOnlySet.iteratorToHashCode(this.iteratorFunction.get());
    }
}

