/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.facade;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.icollection.facade.ReadOnlyMapFacade;
import org.jhotdraw8.icollection.readonly.ReadOnlySortedMap;
import org.jspecify.annotations.Nullable;

public class ReadOnlySortedMapFacade<K, V>
extends ReadOnlyMapFacade<K, V>
implements ReadOnlySortedMap<K, V> {
    private final Supplier<Map.Entry<K, V>> firstEntryFunction;
    private final Supplier<Map.Entry<K, V>> lastEntryFunction;
    private final Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction;
    private final int characteristics;
    private final Supplier<Comparator<? super K>> comparatorSupplier;

    public ReadOnlySortedMapFacade(SortedMap<K, V> target) {
        super(target);
        this.firstEntryFunction = target::firstEntry;
        this.lastEntryFunction = target::lastEntry;
        this.reverseIteratorFunction = () -> target.reversed().sequencedEntrySet().iterator();
        this.characteristics = 81;
        this.comparatorSupplier = target::comparator;
    }

    public ReadOnlySortedMapFacade(Supplier<Iterator<Map.Entry<K, V>>> iteratorFunction, Supplier<Iterator<Map.Entry<K, V>>> reverseIteratorFunction, IntSupplier sizeFunction, Predicate<Object> containsKeyFunction, Function<K, V> getFunction, Supplier<Map.Entry<K, V>> firstEntryFunction, Supplier<Map.Entry<K, V>> lastEntryFunction, int characteristics, @Nullable Supplier<Comparator<? super K>> comparator) {
        super(iteratorFunction, sizeFunction, containsKeyFunction, getFunction);
        this.firstEntryFunction = firstEntryFunction;
        this.lastEntryFunction = lastEntryFunction;
        this.reverseIteratorFunction = reverseIteratorFunction;
        this.characteristics = characteristics;
        this.comparatorSupplier = comparator;
    }

    @Override
    public ReadOnlySortedMap<K, V> readOnlyReversed() {
        return new ReadOnlySortedMapFacade<K, V>(this.reverseIteratorFunction, this.iteratorFunction, this.sizeFunction, this.containsKeyFunction, this.getFunction, this.lastEntryFunction, this.firstEntryFunction, this.characteristics, () -> this.comparatorSupplier.get().reversed());
    }

    @Override
    public  @Nullable Map.Entry<K, V> firstEntry() {
        return this.firstEntryFunction.get();
    }

    @Override
    public  @Nullable Map.Entry<K, V> lastEntry() {
        return this.lastEntryFunction.get();
    }

    @Override
    public @Nullable Comparator<? super K> comparator() {
        return this.comparatorSupplier.get();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

