/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.immutable;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;
import org.jspecify.annotations.Nullable;

public interface ImmutableMap<K, V>
extends ReadOnlyMap<K, V> {
    public ImmutableMap<K, V> clear();

    public ImmutableMap<K, V> put(K var1, @Nullable V var2);

    default public ImmutableMap<K, V> putAll(Map<? extends K, ? extends V> m) {
        return this.putAll(m.entrySet());
    }

    default public ImmutableMap<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> c) {
        ReadOnlyCollection rc;
        Collection co;
        if (c instanceof Collection && (co = (Collection)c).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            return this;
        }
        if (this.isEmpty() && c.getClass() == this.getClass()) {
            return (ImmutableMap)c;
        }
        ImmutableMap<K, V> s = this;
        for (Map.Entry<K, V> e : c) {
            s = s.put(e.getKey(), e.getValue());
        }
        return s;
    }

    default public ImmutableMap<K, V> putKeyValues(Object ... kv) {
        ImmutableMap<Object, Object> that = this;
        for (int i = 0; i < kv.length; i += 2) {
            that = that.put(kv[i], kv[i + 1]);
        }
        return that;
    }

    public ImmutableMap<K, V> remove(K var1);

    default public ImmutableMap<K, V> removeAll(Iterable<? extends K> c) {
        ReadOnlyCollection rc;
        Collection co;
        if (this.isEmpty() || c instanceof Collection && (co = (Collection)c).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            return this;
        }
        ImmutableMap<K, V> s = this;
        for (K k : c) {
            s = s.remove(k);
        }
        return s;
    }

    default public ImmutableMap<K, V> retainAll(Iterable<? extends K> c) {
        Collection cc;
        ImmutableMap s;
        ReadOnlyCollection rc;
        Iterable co;
        if (this.isEmpty()) {
            return this;
        }
        if (c instanceof Collection && (co = (Collection)c).isEmpty() || c instanceof ReadOnlyCollection && (rc = (ReadOnlyCollection)c).isEmpty()) {
            return this.clear();
        }
        if (c instanceof ReadOnlyCollection) {
            co = (ReadOnlyCollection)c;
            if (co.isEmpty()) {
                return this.clear();
            }
            s = this;
            for (Map.Entry e : this) {
                if (co.contains(e)) continue;
                s = s.remove(e);
            }
            return s;
        }
        if (!(c instanceof Collection)) {
            HashSet<? extends K> hm = new HashSet<K>();
            c.forEach(hm::add);
            c = hm;
        }
        if ((cc = (Collection)c).isEmpty()) {
            return this.clear();
        }
        s = this;
        for (Object e : this.readOnlyKeySet()) {
            if (cc.contains(e)) continue;
            s = s.remove(e);
        }
        return s;
    }

    default public ImmutableMap<K, V> retainAll(ReadOnlyCollection<? extends K> c) {
        return this.retainAll(c.asCollection());
    }

    public Map<K, V> toMutable();

    public int maxSize();
}

