/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champ;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champ.BulkChangeEvent;
import org.jhotdraw8.icollection.impl.champ.ChangeEvent;
import org.jhotdraw8.icollection.impl.champ.Node;
import org.jhotdraw8.icollection.impl.champ.NodeFactory;
import org.jhotdraw8.icollection.util.ListHelper;
import org.jspecify.annotations.Nullable;

public class BitmapIndexedNode<D>
extends Node<D> {
    static final BitmapIndexedNode<?> EMPTY_NODE = new BitmapIndexedNode(0, 0, new Object[0]);
    static final boolean DATA_FIRST = true;
    public final Object[] mixed;
    private final int nodeMap;
    private final int dataMap;

    protected BitmapIndexedNode(int nodeMap, int dataMap, Object[] mixed) {
        this.nodeMap = nodeMap;
        this.dataMap = dataMap;
        this.mixed = mixed;
        assert (mixed.length == this.nodeArity() + this.dataArity());
    }

    public static <D> BitmapIndexedNode<D> emptyNode() {
        return EMPTY_NODE;
    }

    private int dataMixedIndex(int dataIndex, Object[] mx) {
        return dataIndex;
    }

    private int nodeMixedIndex(int nodeIndex, Object[] mx) {
        return mx.length - 1 - nodeIndex;
    }

    BitmapIndexedNode<D> copyAndInsertData(@Nullable IdentityObject owner, int bitpos, D data) {
        int idx = this.dataMixedIndex(this.dataIndex(bitpos), this.mixed);
        Object[] dst = ListHelper.copyComponentAdd(this.mixed, idx, 1);
        dst[idx] = data;
        return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap, this.dataMap | bitpos, dst);
    }

    BitmapIndexedNode<D> copyAndMigrateFromDataToNode(@Nullable IdentityObject owner, int bitpos, Node<D> node) {
        int idxOld = this.dataMixedIndex(this.dataIndex(bitpos), this.mixed);
        int idxNew = this.nodeMixedIndex(this.nodeIndex(bitpos), this.mixed);
        Object[] src = this.mixed;
        Object[] dst = new Object[src.length];
        assert (idxOld <= idxNew);
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 1, dst, idxOld, idxNew - idxOld);
        System.arraycopy(src, idxNew + 1, dst, idxNew + 1, src.length - idxNew - 1);
        dst[idxNew] = node;
        return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap | bitpos, this.dataMap ^ bitpos, dst);
    }

    BitmapIndexedNode<D> copyAndMigrateFromNodeToData(@Nullable IdentityObject owner, int bitpos, Node<D> node) {
        int idxOld = this.nodeMixedIndex(this.nodeIndex(bitpos), this.mixed);
        int idxNew = this.dataMixedIndex(this.dataIndex(bitpos), this.mixed);
        Object[] src = this.mixed;
        Object[] dst = new Object[src.length];
        assert (idxOld >= idxNew);
        System.arraycopy(src, 0, dst, 0, idxNew);
        System.arraycopy(src, idxNew, dst, idxNew + 1, idxOld - idxNew);
        System.arraycopy(src, idxOld + 1, dst, idxOld + 1, src.length - idxOld - 1);
        dst[idxNew] = node.getData(0);
        return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap ^ bitpos, this.dataMap | bitpos, dst);
    }

    BitmapIndexedNode<D> copyAndSetNode(@Nullable IdentityObject owner, int bitpos, Node<D> node) {
        int idx = this.nodeMixedIndex(this.nodeIndex(bitpos), this.mixed);
        if (this.isAllowedToUpdate(owner)) {
            this.mixed[idx] = node;
            return this;
        }
        Object[] dst = ListHelper.copySet(this.mixed, idx, node);
        return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap, this.dataMap, dst);
    }

    @Override
    int dataArity() {
        return Integer.bitCount(this.dataMap);
    }

    int dataIndex(int bitpos) {
        return Integer.bitCount(this.dataMap & bitpos - 1);
    }

    int index(int map, int bitpos) {
        return Integer.bitCount(map & bitpos - 1);
    }

    public int dataMap() {
        return this.dataMap;
    }

    @Override
    public boolean equivalent(Object other) {
        if (this == other) {
            return true;
        }
        BitmapIndexedNode that = (BitmapIndexedNode)other;
        Object[] thatNodes = that.mixed;
        int splitAt = this.dataArity();
        return this.nodeMap() == that.nodeMap() && this.dataMap() == that.dataMap() && Arrays.equals(this.mixed, 0, splitAt, thatNodes, 0, splitAt) && Arrays.equals(this.mixed, splitAt, this.mixed.length, thatNodes, splitAt, thatNodes.length, (a, b) -> ((Node)a).equivalent(b) ? 0 : 1);
    }

    @Override
    public @Nullable Object find(D key, int dataHash, int shift, BiPredicate<D, D> equalsFunction) {
        D k;
        int bitpos = BitmapIndexedNode.bitpos(BitmapIndexedNode.mask(dataHash, shift));
        if ((this.nodeMap & bitpos) != 0) {
            return this.getNode(this.nodeIndex(bitpos)).find(key, dataHash, shift + 5, equalsFunction);
        }
        if ((this.dataMap & bitpos) != 0 && equalsFunction.test(k = this.getData(this.dataIndex(bitpos)), key)) {
            return k;
        }
        return NO_DATA;
    }

    @Override
    D getData(int index) {
        return (D)this.mixed[this.dataMixedIndex(index, this.mixed)];
    }

    @Override
    Node<D> getNode(int index) {
        return (Node)this.mixed[this.nodeMixedIndex(index, this.mixed)];
    }

    @Override
    Object getNodeRaw(int index) {
        return this.mixed[this.nodeMixedIndex(index, this.mixed)];
    }

    @Override
    boolean hasData() {
        return this.dataMap != 0;
    }

    @Override
    boolean hasDataArityOne() {
        return Integer.bitCount(this.dataMap) == 1;
    }

    @Override
    boolean hasNodes() {
        return this.nodeMap != 0;
    }

    @Override
    int nodeArity() {
        return Integer.bitCount(this.nodeMap);
    }

    int nodeIndex(int bitpos) {
        return Integer.bitCount(this.nodeMap & bitpos - 1);
    }

    public int nodeMap() {
        return this.nodeMap;
    }

    @Override
    public BitmapIndexedNode<D> remove(@Nullable IdentityObject owner, D data, int dataHash, int shift, ChangeEvent<D> details, BiPredicate<D, D> equalsFunction) {
        int mask = BitmapIndexedNode.mask(dataHash, shift);
        int bitpos = BitmapIndexedNode.bitpos(mask);
        if ((this.dataMap & bitpos) != 0) {
            return this.removeData(owner, data, dataHash, shift, details, bitpos, equalsFunction);
        }
        if ((this.nodeMap & bitpos) != 0) {
            return this.removeSubNode(owner, data, dataHash, shift, details, bitpos, equalsFunction);
        }
        return this;
    }

    private BitmapIndexedNode<D> removeData(@Nullable IdentityObject owner, D data, int dataHash, int shift, ChangeEvent<D> details, int bitpos, BiPredicate<D, D> equalsFunction) {
        int dataIndex = this.dataIndex(bitpos);
        if (!equalsFunction.test(this.getData(dataIndex), data)) {
            return this;
        }
        D currentVal = this.getData(dataIndex);
        details.setRemoved(currentVal);
        if (this.dataArity() == 2 && !this.hasNodes()) {
            int newDataMap = shift == 0 ? this.dataMap ^ bitpos : BitmapIndexedNode.bitpos(BitmapIndexedNode.mask(dataHash, 0));
            Object[] nodes = new Object[]{this.getData(dataIndex ^ 1)};
            return NodeFactory.newBitmapIndexedNode(owner, 0, newDataMap, nodes);
        }
        int idx = this.dataMixedIndex(dataIndex, this.mixed);
        Object[] dst = ListHelper.copyComponentRemove(this.mixed, idx, 1);
        return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap, this.dataMap ^ bitpos, dst);
    }

    private BitmapIndexedNode<D> removeSubNode(@Nullable IdentityObject owner, D data, int dataHash, int shift, ChangeEvent<D> details, int bitpos, BiPredicate<D, D> equalsFunction) {
        Node<D> updatedSubNode;
        Node<D> subNode = this.getNode(this.nodeIndex(bitpos));
        if (subNode == (updatedSubNode = subNode.remove(owner, data, dataHash, shift + 5, details, equalsFunction))) {
            return this;
        }
        if (!updatedSubNode.hasNodes() && updatedSubNode.hasDataArityOne()) {
            if (!this.hasData() && this.nodeArity() == 1) {
                return (BitmapIndexedNode)updatedSubNode;
            }
            return this.copyAndMigrateFromNodeToData(owner, bitpos, updatedSubNode);
        }
        return this.copyAndSetNode(owner, bitpos, updatedSubNode);
    }

    @Override
    public BitmapIndexedNode<D> put(@Nullable IdentityObject owner, @Nullable D newData, int dataHash, int shift, ChangeEvent<D> details, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction) {
        int mask = BitmapIndexedNode.mask(dataHash, shift);
        int bitpos = BitmapIndexedNode.bitpos(mask);
        if ((this.dataMap & bitpos) != 0) {
            int dataIndex = this.dataIndex(bitpos);
            D oldData = this.getData(dataIndex);
            if (equalsFunction.test(oldData, newData)) {
                D updatedData = updateFunction.apply(oldData, newData);
                if (updatedData == oldData) {
                    details.found(oldData);
                    return this;
                }
                details.setReplaced(oldData, updatedData);
                return this.copyAndSetData(owner, dataIndex, updatedData);
            }
            Node<D> updatedSubNode = BitmapIndexedNode.mergeTwoDataEntriesIntoNode(owner, oldData, hashFunction.applyAsInt(oldData), newData, dataHash, shift + 5);
            details.setAdded(newData);
            return this.copyAndMigrateFromDataToNode(owner, bitpos, updatedSubNode);
        }
        if ((this.nodeMap & bitpos) != 0) {
            Node<D> updatedSubNode;
            Node<D> subNode = this.getNode(this.nodeIndex(bitpos));
            return subNode == (updatedSubNode = subNode.put(owner, newData, dataHash, shift + 5, details, updateFunction, equalsFunction, hashFunction)) ? this : this.copyAndSetNode(owner, bitpos, updatedSubNode);
        }
        details.setAdded(newData);
        return this.copyAndInsertData(owner, bitpos, newData);
    }

    private BitmapIndexedNode<D> copyAndSetData(@Nullable IdentityObject owner, int dataIndex, D updatedData) {
        if (this.isAllowedToUpdate(owner)) {
            this.mixed[this.dataMixedIndex((int)dataIndex, (Object[])this.mixed)] = updatedData;
            return this;
        }
        Object[] newMixed = ListHelper.copySet(this.mixed, this.dataMixedIndex(dataIndex, this.mixed), updatedData);
        return NodeFactory.newBitmapIndexedNode(owner, this.nodeMap, this.dataMap, newMixed);
    }

    @Override
    public BitmapIndexedNode<D> putAll(IdentityObject owner, Node<D> other, int shift, BulkChangeEvent bulkChange, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction, ChangeEvent<D> details) {
        BitmapIndexedNode that = (BitmapIndexedNode)other;
        if (this == that) {
            bulkChange.inBoth += this.calculateSize();
            return this;
        }
        int newBitMap = this.nodeMap | this.dataMap | that.nodeMap | that.dataMap;
        Object[] buffer = new Object[Integer.bitCount(newBitMap)];
        int newDataMap = this.dataMap | that.dataMap;
        int newNodeMap = this.nodeMap | that.nodeMap;
        for (int mapToDo = newBitMap; mapToDo != 0; mapToDo ^= Integer.lowestOneBit(mapToDo)) {
            D thatData;
            D thisData;
            Node<Object> thatNode;
            boolean thatIsNode;
            int mask = Integer.numberOfTrailingZeros(mapToDo);
            int bitpos = BitmapIndexedNode.bitpos(mask);
            boolean thisIsData = (this.dataMap & bitpos) != 0;
            boolean thatIsData = (that.dataMap & bitpos) != 0;
            boolean thisIsNode = (this.nodeMap & bitpos) != 0;
            boolean bl = thatIsNode = (that.nodeMap & bitpos) != 0;
            if (!thisIsNode && !thisIsData) {
                if (thatIsData) {
                    buffer[this.dataMixedIndex((int)this.index((int)newDataMap, (int)bitpos), (Object[])buffer)] = that.getData(that.dataIndex(bitpos));
                    continue;
                }
                buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = that.getNode(that.nodeIndex(bitpos));
                continue;
            }
            if (!thatIsNode && !thatIsData) {
                if (thisIsData) {
                    buffer[this.dataMixedIndex((int)this.index((int)newDataMap, (int)bitpos), (Object[])buffer)] = this.getData(this.dataIndex(bitpos));
                    continue;
                }
                buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = this.getNode(this.nodeIndex(bitpos));
                continue;
            }
            if (thisIsNode && thatIsNode) {
                Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                thatNode = that.getNode(that.nodeIndex(bitpos));
                buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = thisNode.putAll(owner, thatNode, shift + 5, bulkChange, updateFunction, equalsFunction, hashFunction, details);
                continue;
            }
            if (thisIsData && thatIsNode) {
                thisData = this.getData(this.dataIndex(bitpos));
                thatNode = that.getNode(that.nodeIndex(bitpos));
                details.reset();
                buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = thatNode.put(null, thisData, hashFunction.applyAsInt(thisData), shift + 5, details, (D a, D b) -> updateFunction.apply(b, a), equalsFunction, hashFunction);
                if (details.isUnchanged()) {
                    ++bulkChange.inBoth;
                } else if (details.isReplaced()) {
                    bulkChange.replaced = true;
                    ++bulkChange.inBoth;
                }
                newDataMap ^= bitpos;
                continue;
            }
            if (thisIsNode) {
                D thatData2 = that.getData(that.dataIndex(bitpos));
                Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                details.reset();
                buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = thisNode.put(owner, thatData2, hashFunction.applyAsInt(thatData2), shift + 5, details, updateFunction, equalsFunction, hashFunction);
                if (!details.isModified()) {
                    ++bulkChange.inBoth;
                }
                newDataMap ^= bitpos;
                continue;
            }
            thisData = this.getData(this.dataIndex(bitpos));
            if (equalsFunction.test(thisData, thatData = that.getData(that.dataIndex(bitpos)))) {
                ++bulkChange.inBoth;
                D updated = updateFunction.apply(thisData, thatData);
                buffer[this.dataMixedIndex((int)this.index((int)newDataMap, (int)bitpos), (Object[])buffer)] = updated;
                bulkChange.replaced = bulkChange.replaced | updated != thisData;
                continue;
            }
            newDataMap ^= bitpos;
            buffer[this.nodeMixedIndex((int)this.index((int)(newNodeMap ^= bitpos), (int)bitpos), (Object[])buffer)] = BitmapIndexedNode.mergeTwoDataEntriesIntoNode(owner, thisData, hashFunction.applyAsInt(thisData), thatData, hashFunction.applyAsInt(thatData), shift + 5);
        }
        return new BitmapIndexedNode<D>(newNodeMap, newDataMap, buffer);
    }

    @Override
    public BitmapIndexedNode<D> removeAll(@Nullable IdentityObject owner, Node<D> other, int shift, BulkChangeEvent bulkChange, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction, ChangeEvent<D> details) {
        BitmapIndexedNode that = (BitmapIndexedNode)other;
        if (this == that) {
            bulkChange.inBoth += this.calculateSize();
            return this;
        }
        int newBitMap = this.nodeMap | this.dataMap;
        Object[] buffer = new Object[Integer.bitCount(newBitMap)];
        int newDataMap = this.dataMap;
        int newNodeMap = this.nodeMap;
        for (int mapToDo = newBitMap; mapToDo != 0; mapToDo ^= Integer.lowestOneBit(mapToDo)) {
            D thatData;
            D thisData;
            Object result;
            Node<D> thatNode;
            boolean thatIsNode;
            int mask = Integer.numberOfTrailingZeros(mapToDo);
            int bitpos = BitmapIndexedNode.bitpos(mask);
            boolean thisIsData = (this.dataMap & bitpos) != 0;
            boolean thatIsData = (that.dataMap & bitpos) != 0;
            boolean thisIsNode = (this.nodeMap & bitpos) != 0;
            boolean bl = thatIsNode = (that.nodeMap & bitpos) != 0;
            if (!thisIsNode && !thisIsData) {
                assert (false);
                continue;
            }
            if (!thatIsNode && !thatIsData) {
                if (thisIsData) {
                    buffer[this.dataMixedIndex((int)this.index((int)newDataMap, (int)bitpos), (Object[])buffer)] = this.getData(this.dataIndex(bitpos));
                    continue;
                }
                buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = this.getNode(this.nodeIndex(bitpos));
                continue;
            }
            if (thisIsNode && thatIsNode) {
                Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                result = thisNode.removeAll(owner, thatNode = that.getNode(that.nodeIndex(bitpos)), shift + 5, bulkChange, updateFunction, equalsFunction, hashFunction, details);
                if (((Node)result).isNodeEmpty()) {
                    newNodeMap ^= bitpos;
                    continue;
                }
                if (((Node)result).hasMany()) {
                    buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = result;
                    continue;
                }
                newNodeMap ^= bitpos;
                buffer[this.dataMixedIndex((int)this.index((int)(newDataMap ^= bitpos), (int)bitpos), (Object[])buffer)] = ((Node)result).getData(0);
                continue;
            }
            if (thisIsData && thatIsNode) {
                thisData = this.getData(this.dataIndex(bitpos));
                thatNode = that.getNode(that.nodeIndex(bitpos));
                result = thatNode.find(thisData, hashFunction.applyAsInt(thisData), shift + 5, equalsFunction);
                if (result == NO_DATA) {
                    buffer[this.dataMixedIndex((int)this.index((int)newDataMap, (int)bitpos), (Object[])buffer)] = thisData;
                    continue;
                }
                newDataMap ^= bitpos;
                ++bulkChange.removed;
                continue;
            }
            if (thisIsNode) {
                D thatData2 = that.getData(that.dataIndex(bitpos));
                Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                details.reset();
                result = thisNode.remove(owner, thatData2, hashFunction.applyAsInt(thatData2), shift + 5, details, equalsFunction);
                if (details.isModified()) {
                    ++bulkChange.removed;
                }
                if (((Node)result).isNodeEmpty()) {
                    newNodeMap ^= bitpos;
                    continue;
                }
                if (((Node)result).hasMany()) {
                    buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = result;
                    continue;
                }
                newNodeMap ^= bitpos;
                buffer[this.dataMixedIndex((int)this.index((int)(newDataMap ^= bitpos), (int)bitpos), (Object[])buffer)] = ((Node)result).getData(0);
                continue;
            }
            thisData = this.getData(this.dataIndex(bitpos));
            if (equalsFunction.test(thisData, thatData = that.getData(that.dataIndex(bitpos)))) {
                ++bulkChange.removed;
                newDataMap ^= bitpos;
                continue;
            }
            buffer[this.dataMixedIndex((int)this.index((int)newDataMap, (int)bitpos), (Object[])buffer)] = thisData;
        }
        return this.newCroppedBitmapIndexedNode(buffer, newDataMap, newNodeMap);
    }

    private BitmapIndexedNode<D> newCroppedBitmapIndexedNode(Object[] buffer, int newDataMap, int newNodeMap) {
        int newLength = Integer.bitCount(newNodeMap | newDataMap);
        if (newLength != buffer.length) {
            Object[] temp = buffer;
            buffer = new Object[newLength];
            int dataCount = Integer.bitCount(newDataMap);
            int nodeCount = Integer.bitCount(newNodeMap);
            System.arraycopy(temp, 0, buffer, 0, dataCount);
            System.arraycopy(temp, temp.length - nodeCount, buffer, dataCount, nodeCount);
        }
        return new BitmapIndexedNode<D>(newNodeMap, newDataMap, buffer);
    }

    @Override
    public BitmapIndexedNode<D> retainAll(IdentityObject owner, Node<D> other, int shift, BulkChangeEvent bulkChange, BiFunction<D, D, D> updateFunction, BiPredicate<D, D> equalsFunction, ToIntFunction<D> hashFunction, ChangeEvent<D> details) {
        BitmapIndexedNode that = (BitmapIndexedNode)other;
        if (this == that) {
            bulkChange.inBoth += this.calculateSize();
            return this;
        }
        int newBitMap = this.nodeMap | this.dataMap;
        Object[] buffer = new Object[Integer.bitCount(newBitMap)];
        int newDataMap = this.dataMap;
        int newNodeMap = this.nodeMap;
        for (int mapToDo = newBitMap; mapToDo != 0; mapToDo ^= Integer.lowestOneBit(mapToDo)) {
            D thatData;
            D thisData;
            Object result;
            Node<D> thatNode;
            boolean thatIsNode;
            int mask = Integer.numberOfTrailingZeros(mapToDo);
            int bitpos = BitmapIndexedNode.bitpos(mask);
            boolean thisIsData = (this.dataMap & bitpos) != 0;
            boolean thatIsData = (that.dataMap & bitpos) != 0;
            boolean thisIsNode = (this.nodeMap & bitpos) != 0;
            boolean bl = thatIsNode = (that.nodeMap & bitpos) != 0;
            if (!thisIsNode && !thisIsData) {
                assert (false);
                continue;
            }
            if (!thatIsNode && !thatIsData) {
                if (thisIsData) {
                    newDataMap ^= bitpos;
                    ++bulkChange.removed;
                    continue;
                }
                newNodeMap ^= bitpos;
                bulkChange.removed += this.getNode(this.nodeIndex(bitpos)).calculateSize();
                continue;
            }
            if (thisIsNode && thatIsNode) {
                Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                result = thisNode.retainAll(owner, thatNode = that.getNode(that.nodeIndex(bitpos)), shift + 5, bulkChange, updateFunction, equalsFunction, hashFunction, details);
                if (((Node)result).isNodeEmpty()) {
                    newNodeMap ^= bitpos;
                    continue;
                }
                if (((Node)result).hasMany()) {
                    buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = result;
                    continue;
                }
                newNodeMap ^= bitpos;
                buffer[this.dataMixedIndex((int)this.index((int)(newDataMap ^= bitpos), (int)bitpos), (Object[])buffer)] = ((Node)result).getData(0);
                continue;
            }
            if (thisIsData && thatIsNode) {
                thisData = this.getData(this.dataIndex(bitpos));
                thatNode = that.getNode(that.nodeIndex(bitpos));
                result = thatNode.find(thisData, hashFunction.applyAsInt(thisData), shift + 5, equalsFunction);
                if (result == NO_DATA) {
                    newDataMap ^= bitpos;
                    ++bulkChange.removed;
                    continue;
                }
                buffer[this.dataMixedIndex((int)this.index((int)newDataMap, (int)bitpos), (Object[])buffer)] = thisData;
                continue;
            }
            if (thisIsNode) {
                D thatData2 = that.getData(that.dataIndex(bitpos));
                Node<D> thisNode = this.getNode(this.nodeIndex(bitpos));
                result = thisNode.find(thatData2, hashFunction.applyAsInt(thatData2), shift + 5, equalsFunction);
                if (result == NO_DATA) {
                    bulkChange.removed += this.getNode(this.nodeIndex(bitpos)).calculateSize();
                    newNodeMap ^= bitpos;
                    continue;
                }
                newNodeMap ^= bitpos;
                buffer[this.dataMixedIndex((int)this.index((int)(newDataMap ^= bitpos), (int)bitpos), (Object[])buffer)] = result;
                bulkChange.removed += this.getNode(this.nodeIndex(bitpos)).calculateSize() - 1;
                continue;
            }
            thisData = this.getData(this.dataIndex(bitpos));
            if (equalsFunction.test(thisData, thatData = that.getData(that.dataIndex(bitpos)))) {
                buffer[this.dataMixedIndex((int)this.index((int)newDataMap, (int)bitpos), (Object[])buffer)] = thisData;
                continue;
            }
            ++bulkChange.removed;
            newDataMap ^= bitpos;
        }
        return this.newCroppedBitmapIndexedNode(buffer, newDataMap, newNodeMap);
    }

    @Override
    public BitmapIndexedNode<D> filterAll(@Nullable IdentityObject owner, Predicate<? super D> predicate, int shift, BulkChangeEvent bulkChange) {
        int newBitMap = this.nodeMap | this.dataMap;
        Object[] buffer = new Object[Integer.bitCount(newBitMap)];
        int newDataMap = this.dataMap;
        int newNodeMap = this.nodeMap;
        for (int mapToDo = newBitMap; mapToDo != 0; mapToDo ^= Integer.lowestOneBit(mapToDo)) {
            boolean thisIsNode;
            int mask = Integer.numberOfTrailingZeros(mapToDo);
            int bitpos = BitmapIndexedNode.bitpos(mask);
            boolean bl = thisIsNode = (this.nodeMap & bitpos) != 0;
            if (thisIsNode) {
                Node<? super D> thisNode = this.getNode(this.nodeIndex(bitpos));
                Node<D> result = thisNode.filterAll(owner, predicate, shift + 5, bulkChange);
                if (result.isNodeEmpty()) {
                    newNodeMap ^= bitpos;
                    continue;
                }
                if (result.hasMany()) {
                    buffer[this.nodeMixedIndex((int)this.index((int)newNodeMap, (int)bitpos), (Object[])buffer)] = result;
                    continue;
                }
                newNodeMap ^= bitpos;
                buffer[this.dataMixedIndex((int)this.index((int)(newDataMap ^= bitpos), (int)bitpos), (Object[])buffer)] = result.getData(0);
                continue;
            }
            D thisData = this.getData(this.dataIndex(bitpos));
            if (predicate.test(thisData)) {
                buffer[this.dataMixedIndex((int)this.index((int)newDataMap, (int)bitpos), (Object[])buffer)] = thisData;
                continue;
            }
            newDataMap ^= bitpos;
            ++bulkChange.removed;
        }
        return this.newCroppedBitmapIndexedNode(buffer, newDataMap, newNodeMap);
    }

    @Override
    protected int calculateSize() {
        int size = this.dataArity();
        int n = this.nodeArity();
        for (int i = 0; i < n; ++i) {
            Node<D> node = this.getNode(i);
            size += node.calculateSize();
        }
        return size;
    }

    private static /* synthetic */ int lambda$equivalent$1(Object a, Object b) {
        return ((Node)a).equivalent(b) ? 0 : 1;
    }
}

