/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champ;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jhotdraw8.icollection.impl.champ.Node;
import org.jspecify.annotations.Nullable;

public class ChampSpliterator<K, E>
extends Spliterators.AbstractSpliterator<E> {
    private final Function<K, E> mappingFunction;
    private static final int MAX_DEPTH = 7;
    protected int currentValueCursor;
    protected int currentValueLength;
    protected Node<K> currentValueNode;
    private int currentStackLevel = -1;
    private final int[] indexAndArity = new int[14];
    final Node<K>[] nodes = new Node[7];
    private K current;

    public ChampSpliterator(Node<K> rootNode, @Nullable Function<K, E> mappingFunction, long size, int characteristics) {
        super(size, characteristics);
        Function<Object, Object> function = this.mappingFunction = mappingFunction == null ? k -> k : mappingFunction;
        if (rootNode.hasNodes()) {
            this.currentStackLevel = 0;
            this.nodes[0] = rootNode;
            this.indexAndArity[0] = 0;
            this.indexAndArity[1] = rootNode.nodeArity();
        }
        if (rootNode.hasData()) {
            this.currentValueNode = rootNode;
            this.currentValueCursor = 0;
            this.currentValueLength = rootNode.dataArity();
        }
    }

    private boolean searchNextValueNode() {
        while (this.currentStackLevel >= 0) {
            int index = this.currentStackLevel << 1;
            if (this.indexAndArity[index] < this.indexAndArity[index + 1]) {
                Node<K> nextNode = this.nodes[this.currentStackLevel].getNode(this.indexAndArity[index]);
                int n = index;
                this.indexAndArity[n] = this.indexAndArity[n] + 1;
                if (nextNode.hasNodes()) {
                    ++this.currentStackLevel;
                    this.nodes[this.currentStackLevel] = nextNode;
                    this.indexAndArity[index += 2] = 0;
                    this.indexAndArity[index + 1] = nextNode.nodeArity();
                }
                if (!nextNode.hasData()) continue;
                this.currentValueNode = nextNode;
                this.currentValueCursor = 0;
                this.currentValueLength = nextNode.dataArity();
                return true;
            }
            --this.currentStackLevel;
        }
        return false;
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        if (this.currentValueCursor < this.currentValueLength || this.searchNextValueNode()) {
            action.accept(this.mappingFunction.apply(this.currentValueNode.getData(this.currentValueCursor++)));
            return true;
        }
        return false;
    }
}

