/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champ;

import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class ChangeEvent<D> {
    private Type type = Type.UNCHANGED;
    private @Nullable D oldData;
    private @Nullable D newData;

    public boolean isUnchanged() {
        return this.type == Type.UNCHANGED;
    }

    void found(D data) {
        this.oldData = data;
    }

    public @Nullable D getOldData() {
        return this.oldData;
    }

    public @Nullable D getNewData() {
        return this.newData;
    }

    public D getOldDataNonNull() {
        return Objects.requireNonNull(this.oldData);
    }

    public D getNewDataNonNull() {
        return Objects.requireNonNull(this.newData);
    }

    void setReplaced(@Nullable D oldData, @Nullable D newData) {
        this.oldData = oldData;
        this.newData = newData;
        this.type = Type.REPLACED;
    }

    void setRemoved(@Nullable D oldData) {
        this.oldData = oldData;
        this.type = Type.REMOVED;
    }

    void setAdded(@Nullable D newData) {
        this.newData = newData;
        this.type = Type.ADDED;
    }

    public boolean isModified() {
        return this.type != Type.UNCHANGED;
    }

    public boolean isReplaced() {
        return this.type == Type.REPLACED;
    }

    void reset() {
        this.type = Type.UNCHANGED;
        this.oldData = null;
        this.newData = null;
    }

    static enum Type {
        UNCHANGED,
        ADDED,
        REMOVED,
        REPLACED;

    }
}

