/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champ;

import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.jhotdraw8.icollection.impl.IdentityObject;
import org.jhotdraw8.icollection.impl.champ.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champ.BulkChangeEvent;
import org.jhotdraw8.icollection.impl.champ.ChangeEvent;
import org.jhotdraw8.icollection.impl.champ.HashCollisionNode;
import org.jhotdraw8.icollection.impl.champ.NodeFactory;
import org.jspecify.annotations.Nullable;

public abstract class Node<D> {
    public static final Object NO_DATA = new Object();
    static final int HASH_CODE_LENGTH = 32;
    static final int BIT_PARTITION_SIZE = 5;
    static final int BIT_PARTITION_MASK = 31;
    static final int MAX_DEPTH = 8;
    static final int MAX_SHIFT = 30;

    Node() {
    }

    static int bitpos(int mask) {
        return 1 << mask;
    }

    public static <E> E getFirst(Node<E> node) {
        int dataMap;
        BitmapIndexedNode bxn;
        int nodeMap;
        while (node instanceof BitmapIndexedNode && ((nodeMap = (bxn = (BitmapIndexedNode)node).nodeMap()) | (dataMap = bxn.dataMap())) != 0) {
            int firstNodeBit = Integer.numberOfTrailingZeros(nodeMap);
            int firstDataBit = Integer.numberOfTrailingZeros(dataMap);
            if (nodeMap != 0 && firstNodeBit < firstDataBit) {
                node = node.getNode(0);
                continue;
            }
            return node.getData(0);
        }
        if (node instanceof HashCollisionNode) {
            HashCollisionNode hcn = (HashCollisionNode)node;
            return (E)hcn.getData(0);
        }
        throw new NoSuchElementException();
    }

    public static <E> E getLast(Node<E> node) {
        int dataMap;
        BitmapIndexedNode bxn;
        int nodeMap;
        while (node instanceof BitmapIndexedNode && ((nodeMap = (bxn = (BitmapIndexedNode)node).nodeMap()) | (dataMap = bxn.dataMap())) != 0) {
            if (Integer.compareUnsigned(nodeMap, dataMap) > 0) {
                node = node.getNode(node.nodeArity() - 1);
                continue;
            }
            return node.getData(node.dataArity() - 1);
        }
        if (node instanceof HashCollisionNode) {
            HashCollisionNode hcn = (HashCollisionNode)node;
            return (E)hcn.getData(hcn.dataArity() - 1);
        }
        throw new NoSuchElementException();
    }

    static int mask(int dataHash, int shift) {
        return dataHash >>> shift & 0x1F;
    }

    static <K> Node<K> mergeTwoDataEntriesIntoNode(IdentityObject owner, K k0, int keyHash0, K k1, int keyHash1, int shift) {
        int mask1;
        if (shift >= 32) {
            Object[] entries = new Object[]{k0, k1};
            return NodeFactory.newHashCollisionNode(owner, keyHash0, entries);
        }
        int mask0 = Node.mask(keyHash0, shift);
        if (mask0 != (mask1 = Node.mask(keyHash1, shift))) {
            int dataMap = Node.bitpos(mask0) | Node.bitpos(mask1);
            Object[] entries = new Object[2];
            if (mask0 < mask1) {
                entries[0] = k0;
                entries[1] = k1;
            } else {
                entries[0] = k1;
                entries[1] = k0;
            }
            return NodeFactory.newBitmapIndexedNode(owner, 0, dataMap, entries);
        }
        Node<K> node = Node.mergeTwoDataEntriesIntoNode(owner, k0, keyHash0, k1, keyHash1, shift + 5);
        int nodeMap = Node.bitpos(mask0);
        return NodeFactory.newBitmapIndexedNode(owner, nodeMap, 0, new Object[]{node});
    }

    abstract int dataArity();

    abstract boolean equivalent(Object var1);

    abstract Object find(D var1, int var2, int var3, BiPredicate<D, D> var4);

    abstract @Nullable D getData(int var1);

    @Nullable IdentityObject getOwner() {
        return null;
    }

    abstract Node<D> getNode(int var1);

    abstract Object getNodeRaw(int var1);

    abstract boolean hasData();

    boolean isNodeEmpty() {
        return !this.hasData() && !this.hasNodes();
    }

    boolean hasMany() {
        return this.hasNodes() || this.dataArity() > 1;
    }

    abstract boolean hasDataArityOne();

    abstract boolean hasNodes();

    boolean isAllowedToUpdate(@Nullable IdentityObject y) {
        IdentityObject x = this.getOwner();
        return x != null && x == y;
    }

    abstract int nodeArity();

    abstract Node<D> remove(@Nullable IdentityObject var1, D var2, int var3, int var4, ChangeEvent<D> var5, BiPredicate<D, D> var6);

    abstract Node<D> put(@Nullable IdentityObject var1, D var2, int var3, int var4, ChangeEvent<D> var5, BiFunction<D, D, D> var6, BiPredicate<D, D> var7, ToIntFunction<D> var8);

    protected abstract Node<D> putAll(@Nullable IdentityObject var1, Node<D> var2, int var3, BulkChangeEvent var4, BiFunction<D, D, D> var5, BiPredicate<D, D> var6, ToIntFunction<D> var7, ChangeEvent<D> var8);

    protected abstract Node<D> removeAll(@Nullable IdentityObject var1, Node<D> var2, int var3, BulkChangeEvent var4, BiFunction<D, D, D> var5, BiPredicate<D, D> var6, ToIntFunction<D> var7, ChangeEvent<D> var8);

    protected abstract Node<D> retainAll(@Nullable IdentityObject var1, Node<D> var2, int var3, BulkChangeEvent var4, BiFunction<D, D, D> var5, BiPredicate<D, D> var6, ToIntFunction<D> var7, ChangeEvent<D> var8);

    protected abstract Node<D> filterAll(@Nullable IdentityObject var1, Predicate<? super D> var2, int var3, BulkChangeEvent var4);

    protected abstract int calculateSize();
}

