/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champ;

import java.util.Objects;
import org.jhotdraw8.icollection.impl.champ.SequencedData;
import org.jspecify.annotations.Nullable;

public class SequencedElement<E>
implements SequencedData {
    private final @Nullable E element;
    private final int sequenceNumber;

    public SequencedElement(@Nullable E element) {
        this.element = element;
        this.sequenceNumber = Integer.MIN_VALUE;
    }

    public SequencedElement(@Nullable E element, int sequenceNumber) {
        this.element = element;
        this.sequenceNumber = sequenceNumber;
    }

    public static <E> SequencedElement<E> put(SequencedElement<E> oldK, SequencedElement<E> newK) {
        return oldK;
    }

    public static int keyHash(@Nullable Object a) {
        return Objects.hashCode(a);
    }

    public static <K> int elementKeyHash(SequencedElement<K> a) {
        return Objects.hashCode(a.getElement());
    }

    public static <E> SequencedElement<E> putAndMoveToFirst(SequencedElement<E> oldK, SequencedElement<E> newK) {
        return oldK.getSequenceNumber() == newK.getSequenceNumber() + 1 ? oldK : newK;
    }

    public static <E> SequencedElement<E> putAndMoveToLast(SequencedElement<E> oldK, SequencedElement<E> newK) {
        return oldK.getSequenceNumber() == newK.getSequenceNumber() - 1 ? oldK : newK;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequencedElement that = (SequencedElement)o;
        return Objects.equals(this.element, that.element);
    }

    public int hashCode() {
        return Objects.hashCode(this.element);
    }

    public @Nullable E getElement() {
        return this.element;
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String toString() {
        return "{" + String.valueOf(this.element) + ", seq=" + this.sequenceNumber + "}";
    }
}

