/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.champmap;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.jhotdraw8.icollection.impl.champmap.BitmapIndexedNode;
import org.jhotdraw8.icollection.impl.champmap.HashCollisionNode;
import org.jhotdraw8.icollection.impl.champmap.Node;

public class ChampTrieGraphviz<K, V> {
    private void dumpBitmapIndexedNodeSubTree(Appendable a, BitmapIndexedNode<K, V> node, int entryLength, boolean printValue, boolean printSequenceNumber, int shift, int keyHash) throws IOException {
        int bitpos;
        int mask;
        String id = this.toNodeId(keyHash, shift);
        a.append('n');
        a.append(id);
        a.append(" [label=\"");
        boolean first = true;
        int nodeMap = node.nodeMap();
        int dataMap = node.dataMap();
        int combinedMap = nodeMap | dataMap;
        int n = Integer.bitCount(combinedMap);
        for (int i = 0; i < n; ++i) {
            int n2 = combinedMap & 1 << i;
        }
        for (mask = 0; mask <= 31; ++mask) {
            bitpos = Node.bitpos(mask);
            if (((nodeMap | dataMap) & bitpos) == 0) continue;
            if (first) {
                first = false;
            } else {
                a.append('|');
            }
            a.append("<f");
            a.append(Integer.toString(mask));
            a.append('>');
            if ((dataMap & bitpos) != 0) {
                a.append(Objects.toString(node.getKey(Node.index(dataMap, bitpos))));
                if (!printValue) continue;
                a.append('=');
                a.append(Objects.toString(node.getValue(Node.index(dataMap, bitpos))));
                continue;
            }
            a.append("\u00b7");
        }
        a.append("\"];\n");
        for (mask = 0; mask <= 31; ++mask) {
            bitpos = Node.bitpos(mask);
            int subNodeKeyHash = mask << shift | keyHash;
            if ((nodeMap & bitpos) == 0) continue;
            Node<K, V> subNode = node.nodeAt(bitpos);
            this.dumpSubTrie(a, subNode, entryLength, printValue, printSequenceNumber, shift + 5, subNodeKeyHash);
            a.append('n');
            a.append(id);
            a.append(":f");
            a.append(Integer.toString(mask));
            a.append(" -> n");
            a.append(this.toNodeId(subNodeKeyHash, shift + 5));
            a.append(" [label=\"");
            a.append(this.toArrowId(mask, shift));
            a.append("\"];\n");
        }
    }

    private void dumpHashCollisionNodeSubTree(Appendable a, HashCollisionNode<K, V> node, int entryLength, boolean printValue, boolean printSequenceNumber, int shift, int keyHash) throws IOException {
        a.append("n").append(this.toNodeId(keyHash, shift));
        a.append(" [color=red;label=\"");
        boolean first = true;
        Object[] nodes = node.entries;
        int i = 0;
        int index = 0;
        while (i < nodes.length) {
            if (first) {
                first = false;
            } else {
                a.append('|');
            }
            a.append("<f");
            a.append(Integer.toString(index));
            a.append('>');
            a.append(Objects.toString(nodes[i]));
            if (printValue) {
                a.append('=');
                a.append(Objects.toString(nodes[i + 1]));
            }
            if (printSequenceNumber) {
                a.append(" #");
                a.append(((Integer)nodes[i + entryLength - 1]).toString());
            }
            i += entryLength;
            ++index;
        }
        a.append("\"];\n");
    }

    private void dumpSubTrie(Appendable a, Node<K, V> node, int entryLength, boolean printValue, boolean printSequenceNumber, int shift, int keyHash) throws IOException {
        if (node instanceof BitmapIndexedNode) {
            this.dumpBitmapIndexedNodeSubTree(a, (BitmapIndexedNode)node, entryLength, printValue, printSequenceNumber, shift, keyHash);
        } else {
            this.dumpHashCollisionNodeSubTree(a, (HashCollisionNode)node, entryLength, printValue, printSequenceNumber, shift, keyHash);
        }
    }

    public void dumpTrie(Appendable a, Node<K, V> root, int entryLength, boolean printValue, boolean printSequenceNumber) throws IOException {
        a.append("digraph ChampTrie {\n");
        a.append("node [shape=record];\n");
        this.dumpSubTrie(a, root, entryLength, printValue, printSequenceNumber, 0, 0);
        a.append("}\n");
    }

    public String dumpTrie(Node<K, V> root, int entryLength, boolean printValue, boolean printSequenceNumber) {
        StringBuilder a = new StringBuilder();
        try {
            this.dumpTrie(a, root, entryLength, printValue, printSequenceNumber);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return a.toString();
    }

    private String toArrowId(int mask, int shift) {
        String id = Integer.toBinaryString(mask & 0x1F);
        StringBuilder buf = new StringBuilder();
        for (int i = id.length(); i < Math.min(32 - shift, 5); ++i) {
            buf.append('0');
        }
        buf.append(id);
        return buf.toString();
    }

    private String toNodeId(int keyHash, int shift) {
        if (shift == 0) {
            return "root";
        }
        String id = Integer.toBinaryString(keyHash);
        StringBuilder buf = new StringBuilder();
        for (int i = id.length(); i < shift; ++i) {
            buf.append('0');
        }
        buf.append(id);
        return buf.toString();
    }
}

