/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.iteration;

import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.function.IntSupplier;

public class FailFastListIterator<E>
implements ListIterator<E> {
    private final ListIterator<E> i;
    private int expectedModCount;
    private final IntSupplier modCountSupplier;
    private final Runnable removeFunction;

    public FailFastListIterator(ListIterator<E> i, IntSupplier modCountSupplier) {
        this(i, i::remove, modCountSupplier);
    }

    public FailFastListIterator(ListIterator<E> i, Runnable removeFunction, IntSupplier modCountSupplier) {
        this.i = i;
        this.modCountSupplier = modCountSupplier;
        this.expectedModCount = modCountSupplier.getAsInt();
        this.removeFunction = removeFunction;
    }

    @Override
    public boolean hasNext() {
        this.ensureUnmodified();
        return this.i.hasNext();
    }

    @Override
    public E next() {
        this.ensureUnmodified();
        return this.i.next();
    }

    @Override
    public boolean hasPrevious() {
        this.ensureUnmodified();
        return this.i.hasPrevious();
    }

    @Override
    public E previous() {
        this.ensureUnmodified();
        return this.i.previous();
    }

    @Override
    public int nextIndex() {
        this.ensureUnmodified();
        return this.i.nextIndex();
    }

    @Override
    public int previousIndex() {
        this.ensureUnmodified();
        return this.i.previousIndex();
    }

    protected void ensureUnmodified() {
        if (this.expectedModCount != this.modCountSupplier.getAsInt()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void remove() {
        this.ensureUnmodified();
        this.removeFunction.run();
        this.updateModified();
    }

    @Override
    public void set(E e) {
        this.ensureUnmodified();
        this.i.set(e);
        this.updateModified();
    }

    @Override
    public void add(E e) {
        this.ensureUnmodified();
        this.i.add(e);
        this.updateModified();
    }

    private void updateModified() {
        this.expectedModCount = this.modCountSupplier.getAsInt();
    }
}

