/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.impl.iteration;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jhotdraw8.icollection.impl.iteration.AbstractListIteratorSpliterator;
import org.jspecify.annotations.Nullable;

public class ReverseListSpliterator<E>
extends AbstractListIteratorSpliterator<E> {
    private int index;
    private final int fromInclusive;
    private final int toExclusive;
    private E current;
    private final List<E> list;

    public ReverseListSpliterator(List<E> list, int fromInclusive, int toExclusive) {
        this.index = fromInclusive;
        this.fromInclusive = fromInclusive;
        this.toExclusive = toExclusive;
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.toExclusive;
    }

    public boolean moveNext() {
        return this.tryAdvance((Consumer<? super E>)((Consumer<Object>)e -> {
            this.current = e;
        }));
    }

    public E current() {
        return this.current;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.list.get(this.list.size() - 1 - this.index++);
        return this.current;
    }

    @Override
    public boolean hasPrevious() {
        return this.index >= this.fromInclusive;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.current = this.list.get(this.index--);
        return this.current;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        if (this.hasNext()) {
            action.accept(this.next());
            return true;
        }
        return false;
    }

    @Override
    public @Nullable Spliterator<E> trySplit() {
        ReverseListSpliterator<E> reverseListSpliterator;
        int lo = this.index;
        int hi = this.toExclusive;
        int mid = lo + hi >>> 1;
        if (lo >= mid) {
            reverseListSpliterator = null;
        } else {
            this.index = mid;
            ReverseListSpliterator<E> reverseListSpliterator2 = new ReverseListSpliterator<E>(this.list, lo, this.index);
            reverseListSpliterator = reverseListSpliterator2;
        }
        return reverseListSpliterator;
    }

    @Override
    public long estimateSize() {
        return this.toExclusive - this.index;
    }
}

