/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.readonly;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import org.jhotdraw8.icollection.facade.ListFacade;
import org.jhotdraw8.icollection.impl.iteration.ReadOnlyListSpliterator;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedCollection;
import org.jspecify.annotations.Nullable;

public interface ReadOnlyList<E>
extends ReadOnlySequencedCollection<E> {
    public E get(int var1);

    default public E getLast(int index) {
        return this.get(this.size() - index - 1);
    }

    @Override
    default public E getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    default public E getLast() {
        int index = this.size() - 1;
        if (index < 0) {
            throw new NoSuchElementException();
        }
        return this.get(index);
    }

    default public @Nullable E peekFirst() {
        return this.isEmpty() ? null : (E)this.get(0);
    }

    default public @Nullable E peekLast() {
        int index = this.size() - 1;
        return index < 0 ? null : (E)this.get(index);
    }

    @Override
    default public Iterator<E> iterator() {
        return new ReadOnlyListSpliterator(this);
    }

    @Override
    default public Spliterator<E> spliterator() {
        return new ReadOnlyListSpliterator(this);
    }

    default public ListIterator<E> listIterator() {
        return new ReadOnlyListSpliterator(this);
    }

    default public ListIterator<E> listIterator(int index) {
        return new ReadOnlyListSpliterator(this, index, this.size());
    }

    default public List<E> asList() {
        return new ListFacade(this);
    }

    public ReadOnlyList<E> readOnlySubList(int var1, int var2);

    default public int indexOf(Object o) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!Objects.equals(this.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    default public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!Objects.equals(this.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    public static <E> boolean listEquals(ReadOnlyList<E> list, @Nullable Object o) {
        if (o == list) {
            return true;
        }
        if (!(o instanceof ReadOnlyList)) {
            return false;
        }
        ReadOnlyCollection that = (ReadOnlyCollection)o;
        if (that.size() != list.size()) {
            return false;
        }
        Iterator i = that.iterator();
        Iterator<E> j = list.iterator();
        while (j.hasNext()) {
            if (Objects.equals(i.next(), j.next())) continue;
            return false;
        }
        return true;
    }

    public static <E> int iteratorToHashCode(Iterator<E> iterator) {
        int h = 1;
        while (iterator.hasNext()) {
            E e = iterator.next();
            h = 31 * h + (e == null ? 0 : e.hashCode());
        }
        return h;
    }

    public boolean equals(@Nullable Object var1);

    public int hashCode();
}

