/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.readonly;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import org.jhotdraw8.icollection.facade.MapFacade;
import org.jhotdraw8.icollection.facade.ReadOnlyCollectionFacade;
import org.jhotdraw8.icollection.facade.ReadOnlySetFacade;
import org.jhotdraw8.icollection.impl.iteration.MappedIterator;
import org.jhotdraw8.icollection.readonly.ReadOnlyCollection;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;
import org.jspecify.annotations.Nullable;

public interface ReadOnlyMap<K, V>
extends Iterable<Map.Entry<K, V>> {
    public boolean isEmpty();

    public int size();

    public @Nullable V get(Object var1);

    default public @Nullable V getOrDefault(Object key, @Nullable V defaultValue) {
        V v = this.get(key);
        return v != null || this.containsKey(key) ? v : defaultValue;
    }

    public boolean containsKey(@Nullable Object var1);

    default public boolean containsValue(@Nullable Object value) {
        for (Map.Entry<K, V> entry : this) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    default public boolean containsEntry(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            return this.containsKey(entry.getKey()) && Objects.equals(entry.getValue(), this.get(entry.getKey()));
        }
        return false;
    }

    default public ReadOnlySet<Map.Entry<K, V>> readOnlyEntrySet() {
        return new ReadOnlySetFacade<Map.Entry<K, V>>(this::iterator, this::size, this::containsEntry, 256);
    }

    default public ReadOnlySet<K> readOnlyKeySet() {
        return new ReadOnlySetFacade(() -> new MappedIterator<Object, Map.Entry>(this.iterator(), Map.Entry::getKey), this::size, this::containsKey, 0);
    }

    default public ReadOnlyCollection<V> readOnlyValues() {
        return new ReadOnlyCollectionFacade(() -> new MappedIterator<Object, Map.Entry>(this.iterator(), Map.Entry::getValue), this::size, this::containsValue, this.characteristics());
    }

    default public Map<K, V> asMap() {
        return new MapFacade(this);
    }

    public static <K, V> String mapToString(ReadOnlyMap<K, V> map) {
        Iterator<Map.Entry<K, V>> i = map.iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == map ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == map ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public static <K, V> boolean mapEquals(ReadOnlyMap<K, V> map, Object o) {
        if (o == map) {
            return true;
        }
        if (!(o instanceof ReadOnlyMap)) {
            return false;
        }
        ReadOnlyMap that = (ReadOnlyMap)o;
        if (that.size() != map.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : map) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? that.get(key) != null || !that.containsKey(key) : !value.equals(that.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    public static <K, V> int iteratorToHashCode(Iterator<Map.Entry<K, V>> entries) {
        return ReadOnlySet.iteratorToHashCode(entries);
    }

    public boolean equals(Object var1);

    public int hashCode();

    @Override
    public Iterator<Map.Entry<K, V>> iterator();

    @Override
    default public Spliterator<Map.Entry<K, V>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), this.characteristics());
    }

    default public int characteristics() {
        return 65;
    }
}

