/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.sequenced;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.IntSupplier;
import org.jhotdraw8.icollection.impl.iteration.ReverseListSpliterator;
import org.jhotdraw8.icollection.impl.iteration.ReverseMutableListIterator;

public class ReversedListView<E>
extends AbstractList<E>
implements List<E> {
    private final List<E> src;
    private final IntSupplier modCount;

    public ReversedListView(List<E> src, IntSupplier modCount) {
        this.src = src;
        this.modCount = modCount;
    }

    @Override
    public boolean isEmpty() {
        return this.src.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.src.contains(o);
    }

    @Override
    public void clear() {
        this.src.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ReverseMutableListIterator<E>(this.src, index, this.modCount);
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ReverseListSpliterator<E>(this.src, 0, this.src.size());
    }

    @Override
    public int size() {
        return this.src.size();
    }

    @Override
    public List<E> reversed() {
        return this.src;
    }

    @Override
    public boolean add(E e) {
        this.src.addFirst(e);
        return true;
    }

    @Override
    public E set(int index, E element) {
        return this.src.set(this.src.size() - 1 - index, element);
    }

    @Override
    public void add(int index, E element) {
        this.src.add(this.src.size() - index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.rangeCheckForAdd(index);
        boolean modified = false;
        int reverseIndex = this.src.size() - index;
        for (E e : c) {
            this.src.add(reverseIndex, e);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return super.addAll(c);
    }

    @Override
    public E remove(int index) {
        return this.src.remove(this.src.size() - 1 - index);
    }

    @Override
    public int indexOf(Object o) {
        int i = this.src.lastIndexOf(o);
        return i < 0 ? i : this.src.size() - 1 - i;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.src.indexOf(o);
        return i < 0 ? i : this.src.size() - 1 - i;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.src.lastIndexOf(o);
        if (i != -1) {
            this.src.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public void addFirst(E e) {
        this.src.addLast(e);
    }

    @Override
    public void addLast(E e) {
        this.src.addFirst(e);
    }

    @Override
    public E getFirst() {
        return this.src.getLast();
    }

    @Override
    public E getLast() {
        return this.src.getFirst();
    }

    @Override
    public E removeFirst() {
        return this.src.removeLast();
    }

    @Override
    public E removeLast() {
        return this.src.removeFirst();
    }

    @Override
    public E get(int index) {
        return this.src.get(this.src.size() - 1 - index);
    }

    private void rangeCheckForAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }
}

