/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.icollection.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ListHelper {
    private ListHelper() {
    }

    public static <T> T[] copyComponentAdd(T[] src, int index, int numComponents) {
        if (index == src.length) {
            return Arrays.copyOf(src, src.length + numComponents);
        }
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length + numComponents);
        System.arraycopy(src, 0, dst, 0, index);
        System.arraycopy(src, index, dst, index + numComponents, src.length - index);
        return dst;
    }

    public static <T> T[] copyComponentRemove(T[] src, int index, int numComponents) {
        if (index == src.length - numComponents) {
            return Arrays.copyOf(src, src.length - numComponents);
        }
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length - numComponents);
        System.arraycopy(src, 0, dst, 0, index);
        System.arraycopy(src, index + numComponents, dst, index, src.length - index - numComponents);
        return dst;
    }

    public static <T> T[] copySet(T[] src, int index, T value) {
        T[] dst = Arrays.copyOf(src, src.length);
        dst[index] = value;
        return dst;
    }
}

