/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.os.macos;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.os.macos.PListParsers;
import org.w3c.dom.Document;

public class MacOSPreferencesUtil {
    public static final File GLOBAL_PREFERENCES = new File(System.getProperty("user.home"), "Library/Preferences/.GlobalPreferences.plist");
    public static final File FINDER_PREFERENCES = new File(System.getProperty("user.home"), "Library/Preferences/com.apple.finder.plist");
    private static ConcurrentHashMap<File, Map<String, Object>> cachedFiles;

    public static @Nullable String getString(@NonNull File file, @NonNull String key) {
        return (String)MacOSPreferencesUtil.get(file, key);
    }

    public static @NonNull String getString(@NonNull File file, String key, String defaultValue) {
        return (String)MacOSPreferencesUtil.get(file, key, defaultValue);
    }

    public static boolean isStringEqualTo(@NonNull File file, String key, String defaultValue, String compareWithThisValue) {
        return MacOSPreferencesUtil.get(file, key, defaultValue).equals(compareWithThisValue);
    }

    public static @Nullable Object get(@NonNull File file, @NonNull String key) {
        MacOSPreferencesUtil.ensureCached(file);
        Map<String, Object> map = cachedFiles.get(file);
        return map == null ? null : MacOSPreferencesUtil.get(map, key);
    }

    public static @NonNull Map<String, Object> flatten(@NonNull Map<String, Object> map) {
        LinkedHashMap<String, Object> flattened = new LinkedHashMap<String, Object>();
        Object plist = map.get("plist");
        if (plist instanceof List) {
            List list = (List)plist;
            for (Object o : list) {
                if (!(o instanceof Map)) continue;
                flattened.putAll((Map)o);
            }
        }
        return flattened;
    }

    public static @Nullable Object get(@NonNull Map<String, Object> map, @NonNull String key) {
        String[] split = key.split("\t");
        Object plist = map.get("plist");
        if (plist instanceof List) {
            List list = (List)plist;
            for (Object o : list) {
                if (!(o instanceof Map)) continue;
                Map m = (Map)o;
                int n = split.length;
                for (int i = 0; i < n; ++i) {
                    String subkey = split[i];
                    if (!m.containsKey(subkey)) continue;
                    Object value = m.get(subkey);
                    if (i < n - 1 && value instanceof Map) {
                        Map unchecked;
                        m = unchecked = (Map)value;
                        continue;
                    }
                    if (i != n - 1) continue;
                    return value;
                }
            }
        }
        return null;
    }

    public static @NonNull Set<String> getKeySet(@NonNull File file) {
        MacOSPreferencesUtil.ensureCached(file);
        return cachedFiles.get(file).keySet();
    }

    public static void clearAllCaches() {
        cachedFiles.clear();
    }

    public static void clearCache(File f) {
        cachedFiles.remove(f);
    }

    public static Object get(@NonNull File file, String key, Object defaultValue) {
        MacOSPreferencesUtil.ensureCached(file);
        return cachedFiles.get(file).getOrDefault(key, defaultValue);
    }

    private static void ensureCached(@NonNull File file) {
        if (cachedFiles == null) {
            cachedFiles = new ConcurrentHashMap();
        }
        if (!cachedFiles.containsKey(file)) {
            HashMap<String, Object> cache = new HashMap<String, Object>();
            try {
                FileTime lastModifiedTime = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]);
                cache.put("lastModifiedTime", lastModifiedTime);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MacOSPreferencesUtil.readPreferences(file, cache);
            cachedFiles.put(file, Map.copyOf(cache));
        }
    }

    public static boolean isMacOs() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().startsWith("mac");
    }

    public static void readPreferences(@NonNull File file, @NonNull Map<String, Object> cache) {
        cache.clear();
        if (MacOSPreferencesUtil.isMacOs()) {
            try {
                Document plist = PListParsers.readPList(file);
                cache.putAll(PListParsers.toMap(plist));
            }
            catch (Throwable e) {
                Logger.getLogger(MacOSPreferencesUtil.class.getName()).log(Level.WARNING, "Unexpected Exception " + e.getMessage(), e);
            }
        }
    }
}

