/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.os.macos;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.os.macos.BinaryPListParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PListParsers {
    private PListParsers() {
    }

    public static Document readPList(@NonNull File file) throws IOException {
        Document doc;
        try {
            doc = PListParsers.readBinaryPropertyList(file);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            doc = PListParsers.readXmlPropertyList(file);
        }
        if (doc == null) {
            throw new IOException("File is neither an XML PList nor a Binary PList. File: " + String.valueOf(file));
        }
        return doc;
    }

    private static Document readXmlPropertyList(@NonNull File file) throws IOException {
        InputSource inputSource = new InputSource(file.toString());
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
            return builder.parse(inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot create document builder for file: " + String.valueOf(file), e);
        }
        catch (SAXException e) {
            throw new IOException("Illegal file format in file: " + String.valueOf(file), e);
        }
    }

    private static Document readBinaryPropertyList(File file) throws IOException {
        return new BinaryPListParser().parse(file);
    }

    public static Map<String, Object> toMap(@NonNull Document plist) throws IOException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("plist", PListParsers.readNode(plist.getDocumentElement()));
        return map;
    }

    private static Object readNode(@NonNull Element node) throws IOException {
        String name;
        Object value = switch (name = node.getTagName()) {
            case "plist" -> PListParsers.readPList(node);
            case "dict" -> PListParsers.readDict(node);
            case "array" -> PListParsers.readArray(node);
            default -> PListParsers.readValue(node);
        };
        return value;
    }

    private static @NonNull Iterable<Node> getChildren(final @NonNull Element elem) {
        return () -> new Iterator<Node>(){
            int index = 0;
            final NodeList children = elem.getChildNodes();

            @Override
            public boolean hasNext() {
                return this.index < this.children.getLength();
            }

            @Override
            public Node next() {
                return this.children.item(this.index++);
            }
        };
    }

    private static @NonNull Iterable<Element> getChildElements(@NonNull Element elem) {
        return () -> StreamSupport.stream(PListParsers.getChildren(elem).spliterator(), false).filter(e -> e instanceof Element).map(e -> (Element)e).iterator();
    }

    private static @NonNull List<Object> readPList(@NonNull Element plistElem) throws IOException {
        ArrayList<Object> plist = new ArrayList<Object>();
        for (Element child : PListParsers.getChildElements(plistElem)) {
            plist.add(PListParsers.readNode(child));
        }
        return plist;
    }

    private static @NonNull String getContent(@NonNull Element elem) {
        StringBuilder buf = new StringBuilder();
        for (Node child : PListParsers.getChildren(elem)) {
            if (!(child instanceof Text)) continue;
            buf.append(child.getTextContent());
        }
        return buf.toString().trim();
    }

    private static @NonNull Map<String, Object> readDict(@NonNull Element dictElem) throws IOException {
        LinkedHashMap<String, Object> dict = new LinkedHashMap<String, Object>();
        Iterator<Element> iterator = PListParsers.getChildElements(dictElem).iterator();
        while (iterator.hasNext()) {
            Element keyElem = iterator.next();
            if (!"key".equals(keyElem.getTagName())) {
                throw new IOException("missing dictionary key at" + String.valueOf(dictElem));
            }
            Element valueElem = iterator.next();
            Object elemValue = PListParsers.readNode(valueElem);
            dict.put(PListParsers.getContent(keyElem), elemValue);
        }
        return dict;
    }

    private static @NonNull List<Object> readArray(@NonNull Element arrayElem) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        for (Element child : PListParsers.getChildElements(arrayElem)) {
            array.add(PListParsers.readNode(child));
        }
        return array;
    }

    private static Object readValue(@NonNull Element value) throws IOException {
        Object parsedValue;
        switch (value.getTagName()) {
            case "true": {
                parsedValue = true;
                break;
            }
            case "false": {
                parsedValue = false;
                break;
            }
            case "data": {
                parsedValue = Base64.getDecoder().decode(PListParsers.getContent(value));
                break;
            }
            case "date": {
                try {
                    parsedValue = DatatypeFactory.newInstance().newXMLGregorianCalendar(PListParsers.getContent(value));
                    break;
                }
                catch (IllegalArgumentException | DatatypeConfigurationException e) {
                    throw new IOException(e);
                }
            }
            case "real": {
                try {
                    parsedValue = Double.valueOf(PListParsers.getContent(value));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IOException(e);
                }
            }
            case "integer": {
                try {
                    parsedValue = Long.valueOf(PListParsers.getContent(value));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IOException(e);
                }
            }
            default: {
                parsedValue = PListParsers.getContent(value);
            }
        }
        return parsedValue;
    }
}

