/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.os.macos;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class BinaryPListParser {
    private static final boolean DEBUG = false;
    private static final long TIMER_INTERVAL_TIMEBASE = new GregorianCalendar(2001, 0, 1, 1, 0, 0).getTimeInMillis();
    private static DatatypeFactory datatypeFactory;
    private int refCount;
    private int offsetCount;
    private int objectCount;
    private int topLevelOffset;
    private ArrayList<Object> objectTable;
    private @Nullable PosByteArrayInputStream pos;

    public Document parse(File file) throws IOException {
        DocumentBuilder builder;
        byte[] buf;
        long fileLength;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            fileLength = raf.length();
            int bpli = raf.readInt();
            int st00 = raf.readInt();
            if (bpli != 1651534953 || st00 != 1936994352) {
                throw new IOException("parseHeader: File does not start with 'bplist00' magic.");
            }
            raf.seek(fileLength - 32L);
            this.offsetCount = (int)raf.readLong();
            this.refCount = (int)raf.readLong();
            this.objectCount = (int)raf.readLong();
            this.topLevelOffset = (int)raf.readLong();
            if (this.offsetCount < 0 || this.refCount < 0 || this.objectCount < 0 || this.topLevelOffset < 0) {
                throw new IOException("file is too large");
            }
            buf = new byte[this.topLevelOffset - 8];
            raf.seek(8L);
            raf.readFully(buf);
        }
        this.objectTable = new ArrayList();
        this.pos = new PosByteArrayInputStream(buf);
        try (DataInputStream in = new DataInputStream(this.pos);){
            this.parseObjectTable(in);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot create document builder", e);
        }
        builder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
        Document doc = builder.newDocument();
        Element root = doc.createElement("plist");
        doc.appendChild(root);
        root.setAttribute("version", "1.0");
        this.convertObjectTableToXML(doc, root, this.objectTable.getFirst(), (int)fileLength);
        return doc;
    }

    private long getPosition() {
        return this.pos.getPos() + 8;
    }

    private void convertObjectTableToXML(Document doc, Element parent, Object object, int remainingRecursion) throws IOException {
        Element elem;
        if (remainingRecursion < 0) {
            throw new IOException("recursion limit reached");
        }
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BPLDict.class, BPLArray.class, String.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, byte[].class, XMLGregorianCalendar.class, BPLUid.class}, (Object)object2, n)) {
            case 0: {
                BPLDict dict = (BPLDict)object2;
                elem = doc.createElement("dict");
                for (int i = 0; i < dict.keyref.length; ++i) {
                    Element key = doc.createElement("key");
                    parent.appendChild(key);
                    key.appendChild(doc.createTextNode(dict.getKey(i)));
                    elem.appendChild(key);
                    this.convertObjectTableToXML(doc, elem, dict.getValue(i), remainingRecursion - 1);
                }
                break;
            }
            case 1: {
                BPLArray arr = (BPLArray)object2;
                elem = doc.createElement("array");
                for (int i = 0; i < arr.objref.length; ++i) {
                    this.convertObjectTableToXML(doc, elem, arr.getValue(i), remainingRecursion - 1);
                }
                break;
            }
            case 2: {
                String s = (String)object2;
                elem = doc.createElement("string");
                elem.appendChild(doc.createTextNode(s));
                break;
            }
            case 3: {
                Integer i = (Integer)object2;
                elem = doc.createElement("integer");
                elem.appendChild(doc.createTextNode(object.toString()));
                break;
            }
            case 4: {
                Long l = (Long)object2;
                elem = doc.createElement("integer");
                elem.appendChild(doc.createTextNode(object.toString()));
                break;
            }
            case 5: {
                Float v = (Float)object2;
                elem = doc.createElement("real");
                elem.appendChild(doc.createTextNode(object.toString()));
                break;
            }
            case 6: {
                Double v = (Double)object2;
                elem = doc.createElement("real");
                elem.appendChild(doc.createTextNode(object.toString()));
                break;
            }
            case 7: {
                Boolean b = (Boolean)object2;
                elem = doc.createElement(b != false ? "true" : "false");
                break;
            }
            case 8: {
                byte[] bytes = (byte[])object2;
                elem = doc.createElement("data");
                elem.appendChild(doc.createTextNode(Base64.getEncoder().encodeToString(bytes)));
                break;
            }
            case 9: {
                XMLGregorianCalendar xmlGregorianCalendar = (XMLGregorianCalendar)object2;
                elem = doc.createElement("date");
                elem.appendChild(doc.createTextNode(xmlGregorianCalendar.toXMLFormat() + "Z"));
                break;
            }
            case 10: {
                BPLUid bplUid = (BPLUid)object2;
                elem = doc.createElement("UID");
                elem.appendChild(doc.createTextNode(Integer.toString(bplUid.number())));
                break;
            }
            default: {
                elem = doc.createElement("unsupported");
                elem.appendChild(doc.createTextNode(object.toString()));
            }
        }
        parent.appendChild(elem);
    }

    private void parseObjectTable(DataInputStream in) throws IOException {
        int marker;
        while ((marker = in.read()) != -1) {
            block0 : switch ((marker & 0xF0) >> 4) {
                case 0: {
                    this.parsePrimitive(in, marker & 0xF);
                    break;
                }
                case 1: {
                    int count = 1 << (marker & 0xF);
                    this.parseInteger(in, count);
                    break;
                }
                case 2: {
                    int count = 1 << (marker & 0xF);
                    this.parseReal(in, count);
                    break;
                }
                case 3: {
                    switch (marker & 0xF) {
                        case 3: {
                            this.parseDate(in);
                            break block0;
                        }
                    }
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 4: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseData(in, count);
                    break;
                }
                case 5: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseAsciiString(in, count);
                    break;
                }
                case 6: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseUnicodeString(in, count);
                    break;
                }
                case 7: {
                    return;
                }
                case 8: {
                    int count = (marker & 0xF) + 1;
                    this.parseUID(in, count);
                    break;
                }
                case 9: 
                case 11: 
                case 12: 
                case 14: 
                case 15: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 10: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    if (this.refCount > 255) {
                        this.parseShortArray(in, count);
                        break;
                    }
                    this.parseByteArray(in, count);
                    break;
                }
                case 13: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    if (this.refCount > 255) {
                        this.parseShortDict(in, count);
                        break;
                    }
                    this.parseByteDict(in, count);
                }
            }
        }
    }

    private int readCount(DataInputStream in) throws IOException {
        int marker = in.read();
        if (marker == -1) {
            throw new IOException("variableLengthInt: Illegal EOF in marker");
        }
        if ((marker & 0xF0) >> 4 != 1) {
            throw new IOException("variableLengthInt: Illegal marker " + Integer.toBinaryString(marker));
        }
        int count = 1 << (marker & 0xF);
        int value = 0;
        for (int i = 0; i < count; ++i) {
            int b = in.read();
            if (b == -1) {
                throw new IOException("variableLengthInt: Illegal EOF in value");
            }
            value = value << 8 | b;
        }
        return value;
    }

    private void parsePrimitive(DataInputStream in, int primitive) throws IOException {
        switch (primitive) {
            case 0: {
                this.objectTable.add(null);
                break;
            }
            case 8: {
                this.objectTable.add(Boolean.FALSE);
                break;
            }
            case 9: {
                this.objectTable.add(Boolean.TRUE);
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new IOException("parsePrimitive: illegal primitive " + Integer.toBinaryString(primitive));
            }
        }
    }

    private void parseByteArray(DataInputStream in, int count) throws IOException {
        BPLArray arr = new BPLArray();
        arr.objectTable = this.objectTable;
        arr.objref = new int[count];
        for (int i = 0; i < count; ++i) {
            arr.objref[i] = in.readByte() & 0xFF;
            if (arr.objref[i] != -1) continue;
            throw new IOException("parseByteArray: illegal EOF in objref*");
        }
        this.objectTable.add(arr);
    }

    private void parseShortArray(DataInputStream in, int count) throws IOException {
        BPLArray arr = new BPLArray();
        arr.objectTable = this.objectTable;
        arr.objref = new int[count];
        for (int i = 0; i < count; ++i) {
            arr.objref[i] = in.readShort() & 0xFFFF;
            if (arr.objref[i] != -1) continue;
            throw new IOException("parseShortArray: illegal EOF in objref*");
        }
        this.objectTable.add(arr);
    }

    private void parseData(DataInputStream in, int count) throws IOException {
        byte[] data = new byte[count];
        in.readFully(data);
        this.objectTable.add(data);
    }

    private void parseByteDict(DataInputStream in, int count) throws IOException {
        int i;
        BPLDict dict = new BPLDict();
        dict.objectTable = this.objectTable;
        dict.keyref = new int[count];
        dict.objref = new int[count];
        for (i = 0; i < count; ++i) {
            dict.keyref[i] = in.readByte() & 0xFF;
        }
        for (i = 0; i < count; ++i) {
            dict.objref[i] = in.readByte() & 0xFF;
        }
        this.objectTable.add(dict);
    }

    private void parseShortDict(DataInputStream in, int count) throws IOException {
        int i;
        BPLDict dict = new BPLDict();
        dict.objectTable = this.objectTable;
        dict.keyref = new int[count];
        dict.objref = new int[count];
        for (i = 0; i < count; ++i) {
            dict.keyref[i] = in.readShort() & 0xFFFF;
        }
        for (i = 0; i < count; ++i) {
            dict.objref[i] = in.readShort() & 0xFFFF;
        }
        this.objectTable.add(dict);
    }

    private void parseAsciiString(DataInputStream in, int count) throws IOException {
        byte[] buf = new byte[count];
        in.readFully(buf);
        String str = new String(buf, StandardCharsets.US_ASCII);
        this.objectTable.add(str);
    }

    private void parseUID(DataInputStream in, int count) throws IOException {
        if (count > 4) {
            throw new IOException("parseUID: unsupported byte count: " + count);
        }
        byte[] uid = new byte[count];
        in.readFully(uid);
        this.objectTable.add(new BPLUid(new BigInteger(uid).intValue()));
    }

    private void parseInteger(DataInputStream in, int count) throws IOException {
        byte[] bytes = new byte[count];
        in.readFully(bytes);
        BigInteger bigInteger = new BigInteger(bytes);
        if (bigInteger.bitLength() < 32) {
            this.objectTable.add(bigInteger.intValue());
        } else if (bigInteger.bitLength() < 64) {
            this.objectTable.add(bigInteger.longValue());
        } else {
            this.objectTable.add(bigInteger);
        }
    }

    private void parseReal(DataInputStream in, int count) throws IOException {
        switch (count) {
            case 4: {
                this.objectTable.add(Float.valueOf(in.readFloat()));
                break;
            }
            case 8: {
                this.objectTable.add(in.readDouble());
                break;
            }
            default: {
                throw new IOException("parseReal: unsupported byte count:" + count);
            }
        }
    }

    private void parseUnknown(DataInputStream in) throws IOException {
        in.skipBytes(1);
        this.objectTable.add("unknown");
    }

    private void parseDate(DataInputStream in) throws IOException {
        this.objectTable.add(BinaryPListParser.fromTimerInterval(in.readDouble()));
    }

    private void parseUnicodeString(DataInputStream in, int count) throws IOException {
        char[] buf = new char[count];
        for (int i = 0; i < count; ++i) {
            buf[i] = in.readChar();
        }
        String str = new String(buf);
        this.objectTable.add(str);
    }

    private static XMLGregorianCalendar fromTimerInterval(double timerInterval) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(TIMER_INTERVAL_TIMEBASE + (long)timerInterval * 1000L));
        XMLGregorianCalendar xmlgc = BinaryPListParser.getDatatypeFactory().newXMLGregorianCalendar(gc);
        xmlgc.setFractionalSecond(null);
        xmlgc.setTimezone(Integer.MIN_VALUE);
        return xmlgc;
    }

    private static DatatypeFactory getDatatypeFactory() {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException ex) {
                throw new InternalError("Can't create XML datatype factory.", ex);
            }
        }
        return datatypeFactory;
    }

    private static class PosByteArrayInputStream
    extends ByteArrayInputStream {
        public PosByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public int getPos() {
            return this.pos;
        }
    }

    private static class BPLDict {
        ArrayList<Object> objectTable;
        int[] keyref;
        int[] objref;

        private BPLDict() {
        }

        public String getKey(int i) {
            return this.objectTable.get(this.keyref[i]).toString();
        }

        public Object getValue(int i) {
            return this.objectTable.get(this.objref[i]);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("BPLDict{");
            for (int i = 0; i < this.keyref.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this.keyref[i] < 0 || this.keyref[i] >= this.objectTable.size()) {
                    buf.append("#").append(this.keyref[i]);
                } else if (this.objectTable.get(this.keyref[i]) == this) {
                    buf.append("*").append(this.keyref[i]);
                } else {
                    buf.append(this.objectTable.get(this.keyref[i]));
                }
                buf.append(":");
                if (this.objref[i] < 0 || this.objref[i] >= this.objectTable.size()) {
                    buf.append("#").append(this.objref[i]);
                    continue;
                }
                if (this.objectTable.get(this.objref[i]) == this) {
                    buf.append("*").append(this.objref[i]);
                    continue;
                }
                buf.append(this.objectTable.get(this.objref[i]));
            }
            buf.append('}');
            return buf.toString();
        }
    }

    private static class BPLArray {
        ArrayList<Object> objectTable;
        int[] objref;

        private BPLArray() {
        }

        public Object getValue(int i) {
            return this.objectTable.get(this.objref[i]);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("Array{");
            for (int i = 0; i < this.objref.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this.objectTable.size() > this.objref[i] && this.objectTable.get(this.objref[i]) != this) {
                    buf.append(this.objectTable.get(this.objref[i]));
                    continue;
                }
                buf.append("*").append(this.objref[i]);
            }
            buf.append('}');
            return buf.toString();
        }
    }

    private record BPLUid(int number) {
    }
}

