/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.os.macos;

import java.util.LinkedHashMap;
import javafx.scene.paint.Color;
import org.jhotdraw8.os.AbstractSystemPreferences;
import org.jhotdraw8.os.macos.MacOSPreferencesUtil;

public class MacOsSystemPreferences
extends AbstractSystemPreferences {
    public void load() {
        LinkedHashMap<String, Object> prefs = new LinkedHashMap<String, Object>();
        MacOSPreferencesUtil.readPreferences(MacOSPreferencesUtil.GLOBAL_PREFERENCES, prefs);
        Object interfaceStyleValue = MacOSPreferencesUtil.get(prefs, "AppleInterfaceStyle");
        if (interfaceStyleValue instanceof String) {
            String str = (String)interfaceStyleValue;
            this.appearance.set((Object)str);
        }
        Object accentColorValue = MacOSPreferencesUtil.get(prefs, "AppleAccentColor");
        Color accentColor = Color.BLACK;
        if (accentColorValue instanceof Number) {
            int accentColorIntValue = ((Number)accentColorValue).intValue();
            if ("Dark".equals(interfaceStyleValue)) {
                switch (accentColorIntValue) {
                    case 0: {
                        accentColor = Color.web((String)"#ec5f5e");
                        break;
                    }
                    case 1: {
                        accentColor = Color.web((String)"#e8883a");
                        break;
                    }
                    case 2: {
                        accentColor = Color.web((String)"#f7c844");
                        break;
                    }
                    case 3: {
                        accentColor = Color.web((String)"#77b856");
                        break;
                    }
                    case 4: {
                        accentColor = Color.web((String)"#3378F7");
                        break;
                    }
                    case 5: {
                        accentColor = Color.web((String)"#9a55a2");
                        break;
                    }
                    case 6: {
                        accentColor = Color.web((String)"#e45c9c");
                        break;
                    }
                    case -1: {
                        accentColor = Color.web((String)"#8c8c8c");
                        break;
                    }
                }
            } else {
                switch (accentColorIntValue) {
                    case 0: {
                        accentColor = Color.web((String)"#cf4745");
                        break;
                    }
                    case 1: {
                        accentColor = Color.web((String)"#e8883a");
                        break;
                    }
                    case 2: {
                        accentColor = Color.web((String)"#f7c94e");
                        break;
                    }
                    case 3: {
                        accentColor = Color.web((String)"#78b957");
                        break;
                    }
                    case 4: {
                        accentColor = Color.web((String)"#3378F6");
                        break;
                    }
                    case 5: {
                        accentColor = Color.web((String)"#8a4292");
                        break;
                    }
                    case 6: {
                        accentColor = Color.web((String)"#e45c9c");
                        break;
                    }
                    case -1: {
                        accentColor = Color.web((String)"#989898");
                        break;
                    }
                }
            }
        }
        if (accentColorValue != null) {
            System.out.println("accentColorValue " + String.valueOf(accentColorValue) + " " + String.valueOf(accentColorValue.getClass()));
        }
    }
}

