/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.svg.figure;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.css.value.CssTransforms;
import org.jhotdraw8.draw.figure.AbstractCompositeFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Grouping;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.ResizableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.svg.figure.SvgDefaultableFigure;
import org.jhotdraw8.svg.figure.SvgElementFigure;
import org.jhotdraw8.svg.figure.SvgTransformableFigure;

public class SvgGFigure
extends AbstractCompositeFigure
implements Grouping,
ResizableFigure,
SvgTransformableFigure,
HideableFigure,
StyleableFigure,
LockableFigure,
SvgDefaultableFigure,
SvgElementFigure {
    public static final String TYPE_SELECTOR = "g";

    public @NonNull Node createNode(@NonNull RenderContext drawingView) {
        Group g = new Group();
        g.setAutoSizeChildren(false);
        g.setManaged(false);
        return g;
    }

    public @NonNull String getTypeSelector() {
        return TYPE_SELECTOR;
    }

    @Override
    public void reshapeInLocal(Transform transform) {
        this.flattenTransforms();
        for (Figure child : this.getChildren()) {
            child.reshapeInParent(transform);
        }
    }

    public void reshapeInLocal(@NonNull CssSize x, @NonNull CssSize y, @NonNull CssSize width, @NonNull CssSize height) {
        this.flattenTransforms();
        Transform localTransform = CssTransforms.createReshapeTransform((CssRectangle2D)this.getCssLayoutBounds(), (CssSize)x, (CssSize)y, (CssSize)width, (CssSize)height);
        for (Figure child : this.getChildren()) {
            child.reshapeInParent(localTransform);
        }
    }

    public void updateNode(@NonNull RenderContext ctx, @NonNull Node n) {
        this.applyHideableFigureProperties(ctx, n);
        this.applyTransformableFigureProperties(ctx, n);
        this.applyStyleableFigureProperties(ctx, n);
        this.applySvgDefaultableCompositingProperties(ctx, n);
        ArrayList<Node> nodes = new ArrayList<Node>(this.getChildren().size());
        for (Figure child : this.getChildren()) {
            nodes.add(ctx.getNode(child));
        }
        ObservableList group = ((Group)n).getChildren();
        if (!group.equals(nodes)) {
            group.setAll(nodes);
        }
    }

    public boolean isSuitableParent(@NonNull Figure newParent) {
        return true;
    }

    public boolean isSuitableChild(@NonNull Figure newChild) {
        return true;
    }
}

